/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.io;
import herman.elements.*;
import herman.properties.*;
import herman.pitch.melody.*;
import herman.pitch.tools.ArrayTools;
import herman.pitch.harmony.*;
import herman.pitch.instruments.*;

/** 
 * The PitchInstInput class handles the music element input into the Pitch 
 * Instantiator module from the other Generator modules.
 */
 
public class PitchInstInput {
/** 
 *  The in queue for accompaniment events and chords 
 */
  public static Queue accompInQueue = new Queue();
/** 
 *  The in queue for melody events
 */
  public static Queue melodyInQueue = new Queue();
/** 
 *  The in queue for percussion events
 */
  public static Queue percussionInQueue = new Queue();

  private static Chord lastChord = new Chord();

  private static boolean blockHarmony = false;
  private static boolean blockMelody = false;

/**
 *  Activates the Pitch Instantiatian module, causing it to instantiate the 
 *   pitches of the music elements in its input queues (if these pitches are
 *   not already instantiated).  The fully instantiated elements eventually 
 *   are sent to the Player by the PitchInstOutput class.
 */
  public static void activate() {
    //First handle the accompaniment:
    MusicElement elem = new MusicElement();
    Chord chord = new Chord();
    Event event = new Event();
    

    //Need to clear melody pitches  (if necc.) before doing harmony
    Queue tempMelQueue = new Queue();
    while (melodyInQueue.size() > 0) {
      event = (Event)melodyInQueue.pop();
      if (blockMelody) {
	event.pitch.setToNull();
	event.key.setToNull();
      }
      tempMelQueue.push(event);
    }

    while (accompInQueue.size() > 0) {
      elem = (MusicElement)accompInQueue.pop();
      //  System.out.println("here");
      if (elem.getMusicDefn().equals("chord")) {  //element is a chord	
        chord = (Chord) elem;
	if (blockHarmony) {
	  chord.chordType.setToNull();
	  chord.key.setToNull();
	}
	HarmonyProgression.inQueue.push(chord);
	HarmonyProgression.getNewChord();
	lastChord = chord;
      }
      else {    //element is an event
	//System.out.println("wrong");	
	 event = (Event)elem;
	 //System.out.println("Pitch has event, time = " +event.startTime);
	
	//Pass the event to the ChordInstantiator:
	ChordInstantiator.inQueue.push(event);
      }
    }

    //Next handle the melody:
    while (tempMelQueue.size() > 0) {
      event = (Event)tempMelQueue.pop();
      MelodyProgression.inQueue.push(event);
      MelodyProgression.getNewMelody();
    }

    //Then instantiate the chords:
    ChordInstantiator.activate();

    //Then handle the percussion:
    while (percussionInQueue.size() > 0) {
      event = (Event)percussionInQueue.pop();
      Instrumentation.percussionInQueue.push(event);
    }

    //Then do the instrumentation:
    Instrumentation.activate();

  }

/**
 * Clears the input queues 
 */
  public static void reset() {
    Queue q1 = new Queue();
    Queue q2 = new Queue();
    Queue q3 = new Queue();

    accompInQueue = q1;
    melodyInQueue = q2;
    percussionInQueue = q3;
  }

/**
 * Ignore harmony instantiations
 */
  public static void ignoreHarmony() {
    blockHarmony = true;
  }

/**
 * Ignore melody instantiations
 */
  public static void ignoreMelody() {
    blockMelody = true;
  }

/**
 * Reset for a new phrase
 */
  public static void newPhrase() {
    blockMelody = false;
    blockHarmony = false;
  }

/**
 *  For debugging.
 */
  public static void main(String[] args) {
    PitchStartUp.initialize();
    
    Chord[] chord = new Chord[5];
    Event[] accompEvent = new Event[5];
    Event[] melodyEvent = new Event[10];

    for (int i = 0; i<10; i++) {
      melodyEvent[i] = new Event();
    }
      
    for (int i = 0; i<5; i++) {
      chord[i] = new Chord();
      chord[i].partMelEvent.addElem(melodyEvent[i*2]);
      chord[i].partMelEvent.addElem(melodyEvent[i*2+1]);
      accompInQueue.push(chord[i]);
      accompEvent[i] = new Event();
      accompEvent[i].startTime = 2*i;
      accompEvent[i].duration = 2;
      accompInQueue.push(accompEvent[i]);
    }    

    for (int i = 0; i<4; i++) {
      melodyEvent[i].supConChord.addElem(chord[((int)i/2)]);
      melodyEvent[i].startTime = i;
      melodyEvent[i].duration = 1;
      melodyInQueue.push(melodyEvent[i]);
    } 

    melodyEvent[4].supConChord.addElem(chord[2]);
    melodyEvent[4].supConChord.addElem(chord[3]);
    melodyEvent[4].supConChord.addElem(chord[4]);
    melodyEvent[4].startTime = 4;
      melodyEvent[4].duration = 6;
      melodyInQueue.push(melodyEvent[4]);

    chord[0].harmonyInfo.setLocation("sentence start");
    melodyEvent[0].eventInfo.setLocation("sentence start");

    System.out.println("Starting....");
    System.out.println(" ");

/*   

    Modulation.setModulation("minor");
    
    Cadence.setCadence("pre-cadence");

    */

    activate();
  }
}
