/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.io;
import herman.elements.*;
import herman.properties.*;
import herman.pitch.melody.*;
import herman.pitch.harmony.*;
import herman.pitch.instruments.*;

/** 
 * The FixedPitchSettings class provides a number of fixed paramter settings, 
 *   primarily for use in testing.
 */
 
public class FixedPitchSettings {

  private static StringBuffer description = new StringBuffer();
  
  public static int numOfSettings = 3;

  public static void apply(int s) {
    
    if (s == 0) {
      setDescription("Happy");
      ChordTones.setMaxNonChordTonePercent(30.0f);
      ChordTones.setMinMatchProb(-10.0f);
      float[] prefer = 
      {15.0f,
       20.0f,20.0f,
       15.0f,15.0f,
       10.0f,10.0f,
       8.0f,
       2.0f, 2.0f,
      -3.0f, -3.0f,
      -5.0f,
      -5.0f, -5.0f};
     
      IntervalPreference.setManualPreference(prefer);
      KeyControl.setCurrentMode("major");
      KeyControl.setCurrentKeyType(0);
      DissonanceLevel.setDissonanceLevel(10.0f);
      DissonanceHandling.setDissonancePrep(2);
      DissonanceHandling.setDissonanceRes(2);
      IntervalHarshness.setHarshness(0.0f);
      Cadence.setPhraseResolution(2);
      Instrumentation.setMelodyReg(0);
      Instrumentation.setAccompReg(-2);
      Resolution.finality = 0;
    }
    else if (s==1) {
      setDescription("Minor, but still OK");
      ChordTones.setMaxNonChordTonePercent(40.0f);
      ChordTones.setMinMatchProb(0.0f);
      float[] prefer = 
      {15.0f,
       20.0f,20.0f,
       15.0f,15.0f,
       10.0f,10.0f,
       8.0f,
       2.0f, 2.0f,
      -3.0f, -3.0f,
      -5.0f,
      -5.0f, -5.0f};
     
      IntervalPreference.setManualPreference(prefer);
      KeyControl.setCurrentMode("minor");
      KeyControl.setCurrentKeyType(9);

      DissonanceLevel.setDissonanceLevel(25.0f);
      DissonanceHandling.setDissonancePrep(0);
      DissonanceHandling.setDissonanceRes(2);
      IntervalHarshness.setHarshness(20.0f);
      Cadence.setPhraseResolution(2);
      Instrumentation.setMelodyReg(0);
      Instrumentation.setAccompReg(-2);
      Resolution.finality = 0;
    }
    else if (s==2) {
      setDescription("Minor, more dissonant");
      ChordTones.setMaxNonChordTonePercent(60.0f);
      ChordTones.setMinMatchProb(-10.0f);
      float[] prefer = 
      {15.0f,
       20.0f,20.0f,
       15.0f,15.0f,
       10.0f,10.0f,
       -1.0f,
       -1.0f, -1.0f,
      -3.0f, -3.0f,
      -5.0f,
      -5.0f, -5.0f};
     
      IntervalPreference.setManualPreference(prefer);
      KeyControl.setCurrentMode("minor");
      KeyControl.setCurrentKeyType(7);

      DissonanceLevel.setDissonanceLevel(60.0f);
      DissonanceHandling.setDissonancePrep(0);
      DissonanceHandling.setDissonanceRes(2);
      IntervalHarshness.setHarshness(70.0f);
      Cadence.setPhraseResolution(4);
      Instrumentation.setMelodyReg(1);
      Instrumentation.setAccompReg(-2);
      Resolution.finality = 0;
    }

    System.out.println("PITCH SETTINGS: "+getDescription());
  }

  private static void setDescription(String s) {
    description.insert(0,s);
    description.setLength(s.length());
  }

  private static String getDescription() {
    return description.toString();
  }
}
