/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.instruments;
import herman.elements.*;
import herman.properties.*;
import herman.pitch.io.*;
import herman.pitch.harmony.Queue;
//import herman.pitch.melody.*;
//import herman.pitch.tools.ArrayTools;


/** 
 * The Instrumentation class assigns instrumentation to each of the three
 *   channels of events.
 */
 
public class Instrumentation {
/** 
 *  The in queue for accompaniment events 
 */
  public static Queue accompInQueue = new Queue();
/** 
 *  The in queue for melody events 
 */
  public static Queue melodyInQueue = new Queue();
/** 
 *  The in queue for percussion events 
 */
  public static Queue percussionInQueue = new Queue();

  private static StringBuffer melodyInstr = new StringBuffer("piano");
  private static StringBuffer accompInstr = new StringBuffer("piano");
  private static StringBuffer percussionInstr = new StringBuffer("snare");

  private static int melodyReg = 0;
  private static int accompReg = -2;
  private static int percussionReg = 0;

  private static int melodyCenter = 10;
  private static int melodyUpRange = 14;
  private static int melodyDownRange = 14;

  private static int accompCenter = 10;

//Access Methods

/**
 *  Activates the Instrumentation algorithm and causes it to assign 
 *   assign instrumentation to each event in its input queues
 */
  public static void activate() {
    Event event = new Event();

    //First do the melody
    while (melodyInQueue.size()>0) {
      event = (Event)melodyInQueue.pop();
      event.timbre.setInstrument(melodyInstr.toString());
      event.pitch.setRegister(melodyReg);
      PitchInstOutput.sendOutMelody(event);
    }

    //The the accompaniment
    while (accompInQueue.size() > 0) {
      event = (Event)accompInQueue.pop();
      event.timbre.setInstrument(accompInstr.toString());
      event.pitch.setRegister(accompReg);
      PitchInstOutput.sendOutAccompaniment(event);
    }
    
    //Then the percussion
    while (percussionInQueue.size() > 0) {
      event = (Event)percussionInQueue.pop();
      event.timbre.setInstrument(percussionInstr.toString());
      event.pitch.setRegister(percussionReg);
      PitchInstOutput.sendOutPercussion(event);
    }
  }

/**
 * Set the melody instrumentation
 */
  public static void setMelodyInstr(String instrument) {
    melodyInstr.insert(0,instrument);
    melodyInstr.setLength(instrument.length());
  }

/**
 * Set the accompaniment instrumentation
 */
  public static void setAccompInstr(String instrument) {
    accompInstr.insert(0,instrument);
    accompInstr.setLength(instrument.length());
  }

/**
 * Set the percussion instrumentation
 */
  public static void setPercussionInstr(String instrument) {
    percussionInstr.insert(0,instrument);
    percussionInstr.setLength(instrument.length());
  }

/**
 * Set the melody register
 */
  public static void setMelodyReg(int register) {
    melodyReg = register;
  }

/**
 * Set the accompaniment register
 */
  public static void setAccompReg(int register) {
    accompReg = register;
  }

/**
 * Set the percussion register
 */
  public static void setPercussionReg(int register) {
    percussionReg = register;
  }

/**
 * Set the melody center
 */
  public static void setMelodyCenter(int center) {
    melodyCenter = center % 12;
    if (melodyCenter < 0) melodyCenter = melodyCenter + 12;
  }

/**
 * Set the accompaniment center
 */
  public static void setAccompCenter(int center) {
    accompCenter = center % 12;
    if (accompCenter < 0) accompCenter = accompCenter + 12; 
  }

/**
 * Get the melody center as an integer
 */
  public static int getIntMelodyCenter() {
   return melodyCenter;
  }

/**
 * Get the accompaniment center as an integer
 */
  public static int getIntAccompCenter() {
   return accompCenter;
  }

/**
 * Set the melody range
 */
  public static void setMelodyRange(int down, int up) {
    melodyUpRange = up;
    melodyDownRange = down;
  }

/**
 * Get the melody range
 */
  public static int[] getMelodyRange() {
    int[] range = new int[2];
    range[1] = melodyUpRange;
    range[0] = melodyDownRange;
    return range;
  }

}
