/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.harmony;
import herman.elements.*;
import herman.pitch.tools.*;
/** 
 * The SameChordRules class handles the rules preventing/allowing subsequent 
 *   chords to be of the same type as their immediate predecessor.
 * <p>
 *  In the future, it could be updated to increase variety by preventing
 *   frequent repetition of chords.
 **/

public class SameChordRules {

/**
 *  sameChords is a boolean describing whether or not the rules should be 
 *    applied
 */
  public static boolean sameChord = true;

  //The "Not Possible Number"
  private static final float no = -1000.0f;
  private static final float Yes = 1.0f;


  public SameChordRules() { /* Nothing */}
  
/**
 *  Applies the same chord rules based on the status of the boolean
 *   sameChord.  If "true", it will prevent the new chord from being
 *   an exact match of the previous chord.
 */ 
  public static void applySameChordRules(Chord lastChord) {
    int lType = lastChord.chordType.getIntType();
    String lExtra = lastChord.chordType.getStringExtras();
    int lDegree = lastChord.chordType.getIntDegree();
    float[] sameArray = HarmonyProgression.sameChord;
    
    int next = 0;
    ArrayTools.setArrayValue(sameArray,Yes);

    if (sameChord) {             //If the Same Chord rules apply:
   /*  int index = (lDegree-1)*4 + lType;
    *  if (ExtraTonesControl.zeroProb(index, lExtra)) {  
    * // and if current extra can be forced
    * //  to zero
    * //Then Everything Is OK!!
    * //System.out.println(" Same Chord OK");
    *  }
    *  else {     
    */
	 next = lDegree - 1;                //next = current degree
	for (int i = 0; i <= 3; i++) {   //Make those types impossible
	  sameArray[next*4+i] = no;
	}
	// }
    }
  }
     
  
// Access Methods

/**
 *  For debugging.
 */
  public static void main(String[] args) {

  }
}
