/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.harmony;
import herman.elements.*;
import herman.properties.*;
import herman.pitch.melody.*;
import herman.pitch.tools.ArrayTools;

/** The Matchsustain class contains that limit a chord progression so that it can 
 *  match a sustained melody event
 */

public class MatchSustain {
  static float[] sustainChords = new float[28];
  static int[] sustainNotes = new int[12];

  public static void checkSustain(Chord chord) {
    if ((chord.partMelEvent.size() > 0)) {
	Event lastEvent = ((Event)chord.partMelEvent.getLast());
	//if lastEvent has other chords attached:

	/*if the last chord associated with the lastEvent has a startTime
         *  greater than the current chord, the event must be sustained
         * over to the next chord
         */
	if (((Chord)lastEvent.supConChord.getLast()).startTime >
	       chord.startTime) {  

	  //if there is only one event, stretching over this chord
	  //  sustained from the previous chord
	  if ((chord.partMelEvent.size()==1)&&
	      (HarmonyProgression.sustainFlag)) {
	    int[] tempNotes = new int[12];
	    int[] chordTones = ChordTones.getChordTones(chord);
	    boolean flag = false;
	    for (int i = 0; i<chordTones.length; i++) {
	      if (sustainNotes[chordTones[i]] > 0) {
		tempNotes[chordTones[i]] = 1;
		flag = true;
	      }
	    }
	    //if there are common tones, those notes are the new sustain notes
	    // Otherwise, the sustain notes remain the same
	    if (flag) sustainNotes = tempNotes;
	  }

	  //Otherwise, if this is a new sustained note
	  else {
	    int[] chordTones = ChordTones.getChordTones(chord);
	    for (int i = 0; i<12; i++) {
	      sustainNotes[i] = 0;
	    }
	    for (int i = 0; i<chordTones.length; i++) {
	      sustainNotes[chordTones[i]] = 1;
	    }
	  }
	  HarmonyProgression.sustainFlag = true;
	}
	else {HarmonyProgression.sustainFlag = false;} 
	          //lastEvent not sustained...
    }
  }

  public static float[][] matchSustain(Chord chord) {
    float[][] totalChordPoss = new float[28][5];
    float[][] chordPoss = new float[28][5];

    for (int i = 0; i<28; i++) {
      ArrayTools.setArrayValue( totalChordPoss[i], 0.0f );
    }
    Key curKey = new Key(KeyControl.getIntCurrentKeyType(),
			 KeyControl.getCurrentMode());
    Pitch susPitch = new Pitch();
    //For each note in sustainNotes, generate chordPoss
    for (int i = 0; i<12; i++) {
      if (sustainNotes[i] > 0) {
	susPitch.setRelPitch(i);
	chordPoss = ChordTones.getChords(susPitch, curKey);
	for (int j= 0; j<28; j++) {
	  ArrayTools.clipNegative(chordPoss[j]);
	  ArrayTools.add2Array(totalChordPoss[j],chordPoss[j]);
	}
      }
    }
    
    return totalChordPoss;
  }


}
