/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.harmony;
import herman.elements.*;
import herman.properties.*;
import herman.pitch.melody.*;
import herman.pitch.tools.ArrayTools;

/** The MatchMelody class contains that allow a chord to match an instantiated 
 *  melody event.
 */

public class MatchMelody {

  public static float[][] applyMelodyMatching( Chord chord ) {
    float[][] chordPoss = new float[28][5];

    //Melody matching (doesn't require lastChord)
    //     check to see if associated melody instantiated
    if (chord.partMelEvent.size() > 0) {
      for (int i = 0; i<28; i++) {
	ArrayTools.setArrayValue( chordPoss[i], 0.0f );
      }
      for ( int i = 0; i < chord.partMelEvent.size(); i++ ) {
	if (!(((Event)chord.partMelEvent.getElemAt(i)).pitch.isNull())) {
       
	if (ChordTones.mustBeAChordTone((Event)chord.partMelEvent.getElemAt(i),
					chord)) {
	  float[][] newChords = 
	    matchMelody(((Event)chord.partMelEvent.getElemAt(i)),chord);
	  for (int j = 0; j<28; j++) {
	    ArrayTools.add2Array(chordPoss[j], newChords[j]);
	  }	 
	}
	}
      }
    }
    return chordPoss;
  }

 // matchMelody function 
  private static float[][] matchMelody(Event mel, Chord chord) {
    HarmonyProgression.melodyMatchFlag = true;
  
    Key key = new Key(KeyControl.getIntCurrentKeyType(), 
			KeyControl.getCurrentMode());
    //Move to mode if nec. and if chord is the first supCon of mel
    if ((mel.supConChord.size()==1)||
	((Chord)mel.supConChord.getFirst()==chord)) {
      if (MelodyScale.checkFlag()) MelodyScale.moveToMode(mel, key);
    }

    //Get chord possibilities
    float[][] newChords = ChordTones.getChords(mel.pitch, key);
    return newChords;
  }

 


}
