/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.harmony;
import herman.elements.*;
import herman.properties.*;

/** 
 *  The Inversions class is responsible for assigning inversions to chords,
 *  At the moment, it is <em>very</em> limited.  
 */

public class Inversions {
  
  public static void assignInversions(Chord chord, Chord lastChord) {
    if (lastChord == null) {
      chord.inversion.setInversion(0);
      return;
    }

    if (chord.key.getMode().equals("minor")) {

      //in minor V -> I, use 1st inversion of I
      if ((lastChord.chordType.getStringDegree().equals("V"))&&
	  (chord.chordType.getStringDegree().equals("I"))) {
	chord.inversion.setInversion(1);
      }

      //in minor, resolve to 1st inversion
      if ((chord.harmonyInfo.getLocation().equals("resolution"))&&
	  (chord.chordType.getStringDegree().equals("I"))) {
	chord.inversion.setInversion(1);
      }
    }

    //use 2nd inversion if following a 7th after a 4up interval and the 
    // last chord is not in an inversion:
    int extr = lastChord.chordType.getIntExtras();
    if (((extr==1)||(extr==2)||(extr>4))&&
	(lastChord.inversion.getInversion()==0)) {
      int interval = 0;
      int thisDegree = chord.chordType.getIntDegree();
      int lastDegree = lastChord.chordType.getIntDegree();
      interval = thisDegree - lastDegree;

      // 3 and -4 indicate a 4th up (by degree)
      if ((interval == 3)||(interval == (-4))) {
	chord.inversion.setInversion(2);
      }
    }
    return;
  }
}
