/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.harmony;
import herman.pitch.tools.*;

/** 
 * The ExtraTonesControl class serves as the central location for the 
 *    assignment of extra tones to chords.  It receives input from the
 *    DissonanceLevel, DissonanceHandling, PivotRules, and KeyControl
 *    classes, as well as its own parameters.  The HarmonyProgression 
 *    sub-module can then request a vector from ExtraTonesControl that 
 *    gives the extra tone probabilities for a specified degree
 **/

public class ExtraTonesControl {


  //The "Not Possible Number"
  private static final float no = -1000.0f;
  private static final float Yes = 1.0f;
   private static final float Y = 1.0f;

    private static final int[] O0 = {1,2,3,4};
    private static final int[] O1 = {0,2,3,4};
    private static final int[] O2 = {0,1,3,4};
    private static final int[] O3 = {0,1,2,4};
    private static final int[] O4 = {0,1,2,3};

    private static final int[] NB0 = {5,6};
    private static final int[] NB1 = {6,8};
    private static final int[] NB2 = {5,7};
    private static final int[] NB3 = {7,8};
    private static final int[] NB4 = {5,6};

    private static final int[] B0 = {7,8};
    private static final int[] B1 = {5,7};
    private static final int[] B2 = {6,8};
    private static final int[] B3 = {5,6};
    private static final int[] B4 = {7,8};

  //The array describing the extra tone possibilities based on key:
   static float[][] scaleExtras;

  //The array describing the extra tone possibilities based on dissonance
  //  level:
   static float[] disLevelExtras;

  //The array describing the extra tone possibilities based on dissonance
  //  handling:
   private static float[][] disHandleExtras = new float[7][5];

  //The array describing the total extra tone possibilities
  private static float[][] extraTones = 
   {{Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes},
    {Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes,Yes}};
/**
 * The ExtraTonesControl constructor can be called
 */
  public ExtraTonesControl() {
    for (int i = 0; i<28; i++) {
    ArrayTools.setArrayValue(extraTones[i],Yes);
    }
  }

// Check to see if at least one extra probability > 0 
  private static boolean zeroCheck( float[] prob) {
    int greaterThanZeroFlag = 0;
    for (int i = 0; i < prob.length; i++)
      if (prob[i] >= 0.0f)
	greaterThanZeroFlag++;
    return (greaterThanZeroFlag > 0) ? true : false;
  }


// Access Methods

/**
 *  Attempt to force a specific chord type to include a specific extra tone.
 *   Successful attempts return true.
 * @param index  An integer [0-27 ]corresponding to the chord degree & type 
 * @param extra A String specifying the extra tone ("m7", "M7", "m9" or "M9")
 */

  public static boolean force(int index, String extra) {
    int xNum = 0;
    int[] others = new int[4];
    int[] both = new int[2];
    int[] nonBoth = new int[2];
    float scaleExRes = 0.0f;

    if (extra.equals("none")) {xNum = 0; others = O0; 
        nonBoth = NB0; both = B0;}  //this is bogus for xNum = 0
    else if (extra.equals("m7")) {xNum = 1; others = O1; 
        nonBoth = NB1; both = B1;}
    else if (extra.equals("M7")) {xNum = 2; others = O2; 
        nonBoth = NB1; both = B2;}
    else if (extra.equals("m9")) {xNum = 3; others = O3; 
        nonBoth = NB3; both = B3;}
    else if (extra.equals("M9")) {xNum = 4; others = O4; 
        nonBoth = NB4; both = B4;}


    if (xNum == 0) {scaleExRes = Yes;}
    else {scaleExRes = scaleExtras[index][xNum-1];}

    if ((disLevelExtras[xNum] > 0)&&(scaleExRes>0)) {
          // If extra is possible by disLevel and scaleExtras
  
      if (xNum == 0) {                        //If trying to force none
	 float sum = 0.0f;
	 for (int i = 1; i<9; i++) {
	   if (extraTones[index][i] > 0.0f) {
	     sum = sum + extraTones[index][i];   //Sum up other prob's
	   }
	 } 
	 if ((sum > 3.0f)||(extraTones[index][0]==Yes)) {
	   for (int i = 1; i<9; i++) {
	     extraTones[index][i] = no;   //Set other prob's to zero
	   }
	   return true;
	 }
	 else {return false;}
      }

      if (extraTones[index][xNum]>0) {       //If prob. extra still > 0
	for (int i = 0; i<4; i++) {
	  extraTones[index][others[i]] = no;   //Set other singles to zero
	}
	for (int i = 0; i <2; i++) {
	  extraTones[index][nonBoth[i]] = no;   //Set wrong combo.'s to zero
	}
	return true;  //Succeed!
      }
      else if ((extraTones[index][both[0]]>0)||   //If combo. with extra
	       (extraTones[index][both[1]]>0)){   // > 0...
	for (int i = 0; i<4; i++) {
	  extraTones[index][others[i]] = no;   //Set other singles to zero
	}
	for (int i = 0; i <2; i++) {
	  extraTones[index][nonBoth[i]] = no;   //Set wrong combo.'s to zero
	}
	return true;
      }
      else {return false;}
    }
    return false;
  }

/**
 *  Attempt to force a specific chord type to include a specific extra tone.
 *   Successful attempts return true.
 * @param index  An integer [0-27 ]corresponding to the chord degree & type 
 * @param extra An integer [0,4] corresponding to [none, m7, M7, m9, M9].
 */
  public static boolean zeroProb(int index, int extra) {
    if (extra==0) {return zeroProb(index, "none");}
    else if (extra==1) {return zeroProb(index, "m7");}
    else if (extra==2) {return zeroProb(index, "M7");}
    else if (extra==3) {return zeroProb(index, "m9");}
    else if (extra==4) {return zeroProb(index, "M9");}
    return false;
  }

/**
 *  Attempt to force a specific chord type <em> not </em> to include a 
 *   specific extra tone.
 *   Successful attempts return true.
 * @param index  An integer [0-27 ]corresponding to the chord degree & type 
 * @param extra A String specifying the extra tone ("m7", "M7", "m9" or "M9")
 */
  public static boolean zeroProb(int index, String extra) {
    int xNum = 0;
    int[] others = new int[4];
    int[] both = new int[2];
    int[] nonBoth = new int[2];
    float scaleExRes = 0.0f;

  
    if (extra.equals("none")) {xNum = 0; others = O0; 
        nonBoth = NB0; both = B0;}  //this is bogus for xNum = 0
    else if (extra.equals("m7")) {xNum = 1; others = O1; 
        nonBoth = NB1; both = B1;}
    else if (extra.equals("M7")) {xNum = 2; others = O2; 
        nonBoth = NB1; both = B2;}
    else if (extra.equals("m9")) {xNum = 3; others = O3; 
        nonBoth = NB3; both = B3;}
    else if (extra.equals("M9")) {xNum = 4; others = O4; 
        nonBoth = NB4; both = B4;}

    float othersSum = others[0] + others[1] +others[2] +others[3];
    float bothSum = both[0]+both[1];

    if (xNum == 0) {scaleExRes = Yes;}
    else {scaleExRes = scaleExtras[index][xNum-1];}

    

    if ((disLevelExtras[xNum] > 0)&&(scaleExRes > 0)) {
	// If extra is possible by dissonance and scaleExtras
 
      if (xNum == 0) {                        //If trying to force none
	 extraTones[index][0] = no;   //Set none prob to zero
	 float[] testArray = getExtrasVector((index/4 +1),(index % 4));
	 if (zeroCheck(testArray)) {
	   return true;
	 }
	 else {extraTones[index][0] = Yes; return false;}
      }

      else if ((extraTones[index][xNum]==no)&&(bothSum==(no*2.0))) {
	// if extra = no & both = no  ==>  opposite forced
	return true;
      }
      else if ((extraTones[index][xNum]==no)&&(bothSum>(2.0*no))
	       &&(othersSum>(4.0*no))) {
	//if extra = no & both != no & others != 0
	//    ==> not opposite forced alone
	float old1 = extraTones[index][both[0]];
	float old2 = extraTones[index][both[1]];
	extraTones[index][both[0]] = no;    //set both to zero
        extraTones[index][both[1]] = no;
	float[] testArray = getExtrasVector((index/4 +1),(index % 4));
	 if (zeroCheck(testArray)) {
	   return true;
	 }
	 else {extraTones[index][both[0]] = old1; 
	       extraTones[index][both[1]] = old2;
	       return false;
	 }
      }
      else if ((extraTones[index][xNum]==no)&&(bothSum>(2.0*no))
	       &&(othersSum==(4.0*no))) {
	//if extra = no & both != no & others = no
	//         ==> not opposite forced with extra
	return false;
      }
      else if ((extraTones[index][xNum]==Yes)&&(othersSum>0.0f)) {
	//if all > 0 , none forced
	float old1 = extraTones[index][both[0]];
	float old2 = extraTones[index][both[1]];
	float old3 = extraTones[index][xNum];
	extraTones[index][xNum] = no;
	extraTones[index][both[0]] = no;
	extraTones[index][both[1]] = no;
	float[] testArray = getExtrasVector((index/4 +1),(index % 4));
	 if (zeroCheck(testArray)) {
	   return true;
	 }
	 else {extraTones[index][both[0]] =old1; 
	       extraTones[index][both[1]] = old2;
	       extraTones[index][xNum] = old3;
	       return false;
	 }
      }
      else if (extraTones[index][xNum]==Yes) {
	//If extra = Yes (and others = no, see above) extra forced
	return false;
      }
    }
    return true;
  }

  /*  static void setDisHandleSev(int degree) {
    disHandleExtras[degree][1] = Yes;
    disHandleExtras[degree][2] = Yes;
  }
  
  static void setDisHandleNin(int degree) {
    disHandleExtras[degree][3] = Yes;
    disHandleExtras[degree][4] = Yes;
  }
  
  static void clearDisHandleSev() {
    for (int i=0; i<7; i++) {
      disHandleExtras[i][1] = no;
      disHandleExtras[i][2] = no;
    }
  }
  static void clearDisHandleNin() {
    for (int i=0; i<7; i++) {
      disHandleExtras[i][3] = no;
      disHandleExtras[i][4] = no;
    }
  }
  static void resetDisHandleExtras() {
    for (int i=0; i<7; i++) {
      for (int j=0; j<5; j++) {
	disHandleExtras[i][j] = Yes;
      }
    }
  }     */

/**
 *  Returns a float[9] array giving the probabilities that particular
 *   extra tones should be included with a specific chord.
 *@param degree the integer describing the degree [1,7]
 *@param type the integer describing the type [0,3]
 */
  static float[] getExtrasVector( int degree, int type ) {
    int index = (degree - 1)*4 + type;
    float[] extraArray = new float[9];

    ArrayTools.equalizeArrays(extraArray, disLevelExtras);

    // ArrayTools.printArray(extraArray);
    for (int i = 0; i<9; i++) {
      if (extraArray[i] < 0) extraArray[i] = -10.0f;
      extraArray[i] = extraArray[i]+extraTones[index][i];
      if (i > 0) {extraArray[i] = extraArray[i] + scaleExtras[index][i-1];}
      else {extraArray[i] = extraArray[i] + 1.0f;}
       
      if (i < 5) {extraArray[i] = extraArray[i];}
      else if (i == 5) {
	extraArray[i] = extraArray[i];}
      else if (i == 6) {
	extraArray[i] = extraArray[i];}
      else if (i == 7) {
	extraArray[i] = extraArray[i];}
      else if (i == 8) {
	extraArray[i] = extraArray[i];}
    }
    // ArrayTools.printArray(extraArray);
    return extraArray;
  }

/**
 *  Makes each extra tone possible.
 */
  public static void resetExtraTones() {
    for (int i = 0; i<28; i++) {
       ArrayTools.setArrayValue(extraTones[i],Yes);
    }
  }

/**
 *  For debugging.
 */
  public static void main(String[] args) {
    float[][] scale = {{Y,Y,no,Y,no,no,Y,Y},   //I has m7,M7, & M9
   {Y,Y,no,Y,no,no,Y,Y},
   {Y,Y,no,Y,no,no,Y,Y},
   {Y,Y,no,Y,no,no,Y,Y},
   {Y,no,Y,no,Y,no,no,no},   //II has m7 and m9
   {Y,no,Y,no,Y,no,no,no},
   {Y,no,Y,no,Y,no,no,no},
   {Y,no,Y,no,Y,no,no,no},
   {no,Y,no,Y,no,no,no,Y},   //III has M7 and M9
   {no,Y,no,Y,no,no,no,Y}, 
   {no,Y,no,Y,no,no,no,Y}, 
   {no,Y,no,Y,no,no,no,Y}, 
   {Y,no,no,Y,no,no,Y,no},   //IV has m7 and M9
   {Y,no,no,Y,no,no,Y,no},
   {Y,no,no,Y,no,no,Y,no},
   {Y,no,no,Y,no,no,Y,no},
   {Y,no,Y,no,Y,no,no,no},   //V major has m7 and m9
   {Y,no,Y,Y,Y,no,Y,no},   //V minor has m7 and m9,M9
   {Y,no,Y,Y,Y,no,Y,no},
   {Y,no,Y,Y,Y,no,Y,no},
   {no,Y,no,Y,no,no,no,Y},   //VI major has M7 and M9
   {no,Y,no,Y,no,no,no,Y}, 
   {Y,no,Y,no,Y,no,no,no},   //VI diminished has m7 and m9
   {Y,no,Y,no,Y,no,no,no},
   {Y,Y,no,Y,no,no,Y,Y},   //VII major has m7,M7 and M9
   {Y,Y,no,Y,no,no,Y,Y},
   {no,no,Y,no,no,no,no,no},   //VII diminished has m9
   {no,no,Y,no,no,no,no,no}};
   scaleExtras = scale;
    float[] disLevel = {Y,Y,Y,no,no,no,no,no,no};
   disLevelExtras = disLevel;
    for (int i = 0; i<7; i++) {
       ArrayTools.setArrayValue(disHandleExtras[i],Yes);
    }

    zeroProb(26,"none");
    ArrayTools.printArray(getExtrasVector(7,2));
   
  }
 
}
