/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.harmony;
import herman.elements.*;
import herman.pitch.tools.*;
/** 
 * The CommonTones class stores and applies the rules governing the use of 
 *    common tones between adjacent chords.  CommonTones actually overestimates
 *    the number of chords that are possible when in the minor scale, 
 *    relying on
 *    pivot rules to eliminate those chords progressions that chromatically
 *    raise/lower either the 6th or 7th scale tones.
 *  <p>
 *    Although ComonTones takes the 7ths or 9ths of a previous chord into 
 *    account, it does <em>not</em> consider the possibility that the new chord
 *    could be a 7th or 9th.
 **/

public class CommonTones {

/**
 *  commonTones is a boolean describing whether or not the rules should be 
 *    applied
 */
  public static boolean commonTones = true;

  //The "Not Possible Number"
  private static final float no = -1000.0f;
  private static final float Yes = 1.0f;


  public CommonTones() { /* Nothing */}
  

/**
 *  Apply the common tones rules (if commonTones true).  Modifies
 *  HarmonyProgression.commonTones[] appropriately.
 */
  public static void applyCommonTonesRules(Chord lastChord) {
    int lType = lastChord.chordType.getIntType();
    int lExtra = lastChord.chordType.getIntExtras();
    int lDegree = lastChord.chordType.getIntDegree();
    float[] comArray = HarmonyProgression.commonTones;
    
    int next = 0;
   
    if (commonTones) {       //If the Common Tones rules apply:
      ArrayTools.setArrayValue(comArray,no);
      next = lDegree - 1;                //next = current degree
      for (int i = 0; i <= 3; i++) {   //Make those types possible
	  comArray[next*4+i] = Yes;
	}

      next = (((lDegree - 1) + 2) % 7);  //next = 3rd above lDegree
      for (int i = 0; i <= 3; i++) {   //Make those types possible
	  comArray[next*4+i] = Yes;
	}
      next = (((lDegree - 1) + 3) % 7);  //next = 4th above lDegree
      for (int i = 0; i <= 3; i++) {   //Make those types possible
	  comArray[next*4+i] = Yes;
	}
      next = (((lDegree - 1) + 4) % 7);  //next = 5th above lDegree
      for (int i = 0; i <= 3; i++) {   //Make those types possible
	  comArray[next*4+i] = Yes;
	}
      next = (((lDegree - 1) + 5) % 7);  //next = 6th above lDegree
      for (int i = 0; i <= 3; i++) {   //Make those types possible
	  comArray[next*4+i] = Yes;
	}
      
      if ((lExtra == 1)||(lExtra == 2)||(lExtra>4)) {    //If a seventh:
	next = (((lDegree - 1) + 6) % 7);  //next = 7th above lDegree
      for (int i = 0; i <= 3; i++) {   //Make those types possible
	  comArray[next*4+i] = Yes;
	}
      }
      if (lExtra > 2) {                       //If a ninth
	next = (((lDegree - 1) + 1) % 7);  //next = 2nd above lDegree
      for (int i = 0; i <= 3; i++) {   //Make those types possible
	  comArray[next*4+i] = Yes;
	}
      }
    }
    else {ArrayTools.setArrayValue(comArray,Yes);}
  }
// Access Methods

/**
 *  For debugging.
 */
  public static void main(String[] args) {

  }
}
