/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.pitch.harmony;
import herman.elements.*;
import herman.properties.*;
import herman.pitch.melody.*;
import herman.pitch.tools.ArrayTools;
import herman.pitch.instruments.*;

/** 
 * The ChordInstantiator class instantiates the events that comprise each 
 *  each chord with apporpriate pitches.  At the moment, it only creates
 *  root position chords and works (essentially) off a look-up table.
 */
 
public class ChordInstantiator {

/** 
 *  The in queue containing the chords to be instantiated
 */
  public static Queue inQueue = new Queue();
  private static Event lastEvent = new Event();

/**
 * The maximum number of tones per chord
 */
  public static int desiredToneNum = 6;
  private static int[] chordTones = new int[5];

/** 
 * intialize the Chord Instantiator
 */  
  public static void initialize() {
    lastEvent.startTime = -1;
  }

  private static Chord currentChord = new Chord();

  private static int lastThird = 0;

/**
 *  Activates the ChordInstantiator.  Causes all of the events in its input
 *   queue to be instantiated to a particular pitch based on the relevant
 *   chord.
 */
  public static void activate() {
    //First, pull stuff out of the queue correctly
    MusicElement elem = new MusicElement();
    Chord chord = new Chord();
    Event event = new Event();
    while (inQueue.size() > 0) {
      elem = (MusicElement)inQueue.pop();
      if (elem.getMusicDefn().equals("chord")) {  //element is a chord
        chord = (Chord)elem;
	currentChord = chord;
	chordTones = ChordTones.getChordTones(currentChord);
      
/* ***********THIS MAY NEEED TO BE CHANGED!!!!!!!!!********** */
	System.out.println(currentChord.chordType + " in the key of " 
          + currentChord.key);
	System.out.print("{");
	for (int i = 0; i<chordTones.length; i++) {
	  System.out.print(chordTones[i] + ", "); 
	}
	System.out.println("}");
      

	//clear the current chord's accomp particles
	//TEMPORARILY CHANGED
	//  currentChord.partAccompEvent.removeElems();
      }
      else {                                            //element is an event
	 event = (Event)elem;
	 
	//instantiate the event
	instantiateEvent(event);
      }
    }
  }

  /*Should instantiate the events based on the current chord and
   *  send them to the Instrumentation
   */
  private static void instantiateEvent(Event event) {
    //If this is an old expansion event, ignore it
    if (event.startTime == lastEvent.startTime) return;

    //Otherwise
    Event[] eventArray = expandEvent(event);
    allocateNotes(eventArray);
    for (int i = 0; i<eventArray.length; i++) {
      Instrumentation.accompInQueue.push(eventArray[i]);
      //Add event to the the currentChord's constituents;
      // TEMPORARILY CHANGED!!!!
      //  currentChord.partAccompEvent.addElem((Event)eventArray[i]);
    }
    lastEvent = event;
  }

  /* Expand the intial event into multiple events
   *
   */
  private static Event[] expandEvent(Event event) {
    
    int chordToneNum = 1;

    if (chordTones.length < desiredToneNum) {  //If # chordTones < maxTones
      chordToneNum = chordTones.length;        //create # chordTones events
    } else {chordToneNum = desiredToneNum;}  //Else create maxTones # of events

    //Allow resolution to have the lower root if in inversion
    if ((currentChord.harmonyInfo.getLocation().equals("resolution"))&&
	(currentChord.inversion.getInversion() != 0)){
      chordToneNum++;
    }

    Event[] eventArray = new Event[chordToneNum];
    
    for (int i=0; i<eventArray.length; i++) {
      eventArray[i] = new Event();
      eventArray[i].duration = event.duration;
      eventArray[i].startTime = event.startTime;
      eventArray[i].amplitude.setLevel(event.amplitude.getLevel());
      eventArray[i].velocity = event.velocity;
    }
    return eventArray;
  }
    
  /* Allocate pitches to the events in eventArray
   * This will have to be re-written to handle less than the max 
   *  number of tones
   */
  private static void allocateNotes(Event[] eventArray) { 
    int keyType = currentChord.key.getIntKeyType() % 12;
    if (keyType < 0) keyType = keyType + 12;
    int pitch = 0;
    int lastPitch = 0;
    int center = Instrumentation.getIntAccompCenter();
 
    pitch = (keyType + chordTones[0]) % 12;

    //No inversion
    if (currentChord.inversion.getInversion()==0) {
      //Try to center roughly
      if (pitch > (center + 6)) {pitch = pitch -12;}
      else if (pitch < (center - 5)) {pitch = pitch + 12;}
      //System.out.println("rel pitch = " + pitch);
      eventArray[0].pitch.setRelPitch(pitch);
      lastPitch = pitch;

      for (int i = 1; i<eventArray.length; i++) {
	pitch = (keyType + chordTones[i]) % 12;
	while (pitch < lastPitch) {pitch = pitch + 12;}
	eventArray[i].pitch.setRelPitch(pitch);
	lastPitch = pitch;
      }
      lastThird = eventArray[1].pitch.getRelPitch();
    }

    /*
     *  NOTE!!! The inversion instantiations were written specifically
     *    for the original Inversions rules.  They may do strange
     *    things if the Inversions rules are expanded!!!!
     */
    else if (currentChord.inversion.getInversion()==1) {
      int root = pitch;

      pitch = (keyType + chordTones[1]) % 12;    //ie, the third

      while (pitch <= lastThird) {pitch = pitch + 12;}
      pitch = pitch - 12;    //new third should be in octave below lastThird
      eventArray[0].pitch.setRelPitch(pitch);
      lastPitch = pitch;
      lastThird = pitch;

      pitch = (keyType + chordTones[2]) % 12;    //ie, the fifth
      while (pitch < lastPitch) {pitch = pitch + 12;}
      eventArray[1].pitch.setRelPitch(pitch);
      lastPitch = pitch;

      pitch = root;
      while (pitch < lastPitch) {pitch = pitch + 12;}
      eventArray[2].pitch.setRelPitch(pitch);
      root = pitch;
      lastPitch = pitch;

      if (currentChord.harmonyInfo.getLocation().equals("resolution")) {
	//If on a resolution, include the lower root

	pitch = root - 12;               //Include the lower root
	eventArray[3].pitch.setRelPitch(pitch);

	for (int i = 4; i<eventArray.length; i++) {
	  pitch = (keyType + chordTones[i-1]) % 12;
	  while (pitch < lastPitch) {pitch = pitch + 12;}
	  eventArray[i].pitch.setRelPitch(pitch);
	  lastPitch = pitch;
	}
      }
      else {
	//Otherwise, not on a resolution so no lower root

	for (int i = 3; i<eventArray.length; i++) {
	  pitch = (keyType + chordTones[i]) % 12;
	  while (pitch < lastPitch) {pitch = pitch + 12;}
	  eventArray[i].pitch.setRelPitch(pitch);
	  lastPitch = pitch;
	}
      }
    }

    /*
     *  NOTE!!! The inversion instantiations were written specifically
     *    for the original Inversions rules.  They may do strange
     *    things if the Inversions rules are expanded!!!!
     */
    else  {  //second inversion
      int root = pitch;

      pitch = (keyType + chordTones[2]) % 12;    //ie, the fifth
      while (pitch <= lastThird) {pitch = pitch + 12;}
      pitch = pitch - 12;    //new fifth should be in octave below lastThird
      eventArray[0].pitch.setRelPitch(pitch);
      lastPitch = pitch;

      pitch = root;
      while (pitch < lastPitch) {pitch = pitch + 12;}
      eventArray[1].pitch.setRelPitch(pitch);
      root = pitch;
      lastPitch = pitch;

      pitch = (keyType + chordTones[1]) % 12;    //ie, the third
      while (pitch < lastPitch) {pitch = pitch + 12;}
      eventArray[2].pitch.setRelPitch(pitch);
      lastPitch = pitch;
      lastThird = pitch;
 
      if (currentChord.harmonyInfo.getLocation().equals("resolution")) {
	//If on a resolution, include the lower root

	pitch = root - 12;               //Include the lower root
	eventArray[3].pitch.setRelPitch(pitch);

	for (int i = 4; i<eventArray.length; i++) {
	  pitch = (keyType + chordTones[i-1]) % 12;
	  while (pitch < lastPitch) {pitch = pitch + 12;}
	  eventArray[i].pitch.setRelPitch(pitch);
	  lastPitch = pitch;
	}
      }
      else {
	//Otherwise, not on a resolution so no lower root

	for (int i = 3; i<eventArray.length; i++) {
	  pitch = (keyType + chordTones[i]) % 12;
	  while (pitch < lastPitch) {pitch = pitch + 12;}
	  eventArray[i].pitch.setRelPitch(pitch);
	  lastPitch = pitch;
	}
      }
      
    }

  }
    
}


