/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.misc;

public abstract class Quicksort
{
  public Object[] sort(Object[] unordered)
  {
    return (__sort(unordered, 0, unordered.length-1));
  }
  
  private Object[] __sort(Object[] unordered, int l, int r)
  {
    if (l >= r)
      return(unordered);

    __swap(unordered, l, (l + r)/2);
    int last = l;
    
    for(int i=l+1; i<=r; i++)
      if (compare(unordered[i], unordered[l]) <0)
	__swap(unordered, ++last, i);
    __swap(unordered, l, last);

    __sort(unordered, l, last-1);
    __sort(unordered, last+1, r);
    
    return(unordered);
  }
  
  private void __swap(Object[] unordered, int i, int j)
  {
    Object tmp = unordered[i];
    unordered[i] = unordered[j];
    unordered[j] = tmp;
  }
      

  protected abstract int compare(Object obj1, Object obj2);
}      
      
      
