/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.misc;

public class Queue
{
  private Object[] queue;
  private int queueFirst = 0;
  private int queueLast = 0;
  private int minQueueLength = 0;
  private Boolean lock = new Boolean(true);


  public Queue()
  {
    this.minQueueLength = 10;
    queueFirst=0;
    queueLast=0;
    queue = new Object[minQueueLength];
  }



  public void add(Object obj)
  {
    synchronized(lock)
    {
      // run out of space => make new space
      if (queueLast >= queue.length)
      {
	Object[] tmp = new Object[queue.length*2];
	System.arraycopy(queue, 0, tmp, 0, queue.length);
	queue = tmp;
      }
      
      // add item to end of queue
      queue[queueLast++] = obj;
    }
  }
  

  public Object next()
  {
    synchronized(lock)
    {
      // check we've not run out of elements
      if (queueFirst >= queueLast)
	return(null);
      
      // get queue element & kill off old one
      Object event = queue[queueFirst];
      queue[queueFirst++] = null;

      // now, work out whether we should contract the queue or not
      // if there is more that 1/4 of the queue free, then contract it
      // only if we'll have minQueueLength elements left though!
      if ((((float) queue.length / 
	  (float) ((queue.length - queueLast) + queueFirst)) > 0.25)  &&
	  (((queueLast - queueFirst) +1) > minQueueLength))
      {
	Object tmp[] = new Object[(queueLast - queueFirst) + 1];
	System.arraycopy(queue, queueFirst, tmp, 0, tmp.length);
	queue = tmp;
      }

      return(event);
    }      
  }

  
  public Object read()
  {
    synchronized(lock)
    {
      // check we've not run out of elements
      if (queueFirst >= queueLast)
	return(null);
      
      return(queue[queueFirst]);
    }
  }
  
  public int length()
  {
    synchronized(lock)
    {
      return(queueLast - queueFirst);
    }
  }
}
