/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.misc;


/**
 * Quick class so that we can add a whole load of items dynamically to an
 * array, and then retrieve them, en-masse in one array
 */
public class ItemList
{
  /**
   * The list of items
   */
  private Object[] queue = new Object[10];

  private int queueCount = 0;

  /**
   * Adds a new element into the queue
   *
   * @param obj The element to add
   */
  public void add(Object obj)
  {
    // make new space
    if (queueCount >= queue.length)
    {
      Object[] tmp = new Object[queue.length*2];
      System.arraycopy(queue, 0, tmp, 0, queue.length);
      queue = tmp;
    }
    
    // add item to end of queue
    queue[queueCount++] = obj;
  }



  /**
   * Extracts the elements, en-masse as an array of objects<BR>
   * Note: Doesn't delete them from the queue
   *
   * @return The elements in the queue
   */
  public Object[] getArray()
  {
    Object[] tmp = new Object[queueCount];
    System.arraycopy(queue, 0, tmp, 0, tmp.length);

    return(tmp);
  }

  
  public int length()
  {
    return(queueCount);
  }
  
  public Object getElement(int index)
    throws IndexOutOfBoundsException
  {
    if ((index < 0) || (index >= queueCount))
      throw new IndexOutOfBoundsException();
    
    return(queue[index]);
  }
}  

