/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.midiplayer;
import herman.misc.*;
import herman.midi.*;


/**
 * An object in the queue
 */
public class MidiTemporalQueueObject extends TemporalQueueObject
{
  public MidiEvent event;
  public long time;



  /**
   * Creates a new MidiQueueObject, based around MidiEvent e
   * 
   * @param e The MidiEvent to use
   */
  public MidiTemporalQueueObject(MidiEvent e)
  {
    event = e;
    time = e.time;
  }


  /**
   * extracts the key object for this QueueObject
   *
   * @return The key object
   */
  public Object getKey()
  {
    return((Object) new Long(time));
  }
  
  /**
   * Extracts the actual data object held in this QueueObject
   *
     * @return the data object
     */
  public Object getObject()
  {
    return((Object) event);
  }
}
