/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.midiplayer;
import herman.misc.*;

public class MidiTemporalQueue extends TemporalQueue
{

  /**
   * Compares two key objects together. Returns BEFORE, AFTER or EQUAL,
   * depending on the relationship between e1 & e2 (i.e. if e1 < e2, return 
   * BEFORE
   */
  protected int compareKeys(Object e1, Object e2)
  {
    long time1 = ((Long) e1).longValue();
    long time2 = ((Long) e2).longValue();
    
    if (time1 < time2)
      return(BEFORE);
    
    if (time1 > time2)
      return(AFTER);
    
    return(EQUAL);
  }
}

