/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.midi;
import herman.misc.*;

public class MidiNoteOnEvent extends MidiEvent
{
  public int pitch;
  private int velocity;
  private int channel;
  private String instrument;
  
  private MidiNoteOnEvent() {}
  public MidiNoteOnEvent(int channel, int pitch, int velocity, String instrument,
			 long time)
  {
    this.pitch = pitch;
    this.velocity = velocity;
    this.channel = channel;
    this.instrument = instrument;
    this.time = time;
  }
      
  public void send(MidiOut outDevice)
    throws InvalidMIDIChannelException, NotInitialisedException,
	   MIDIDeviceBusyException, UnknownInstrumentException
  {
    outDevice.noteOn(channel, pitch, velocity, instrument);
  }
}
