/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.midi;
import herman.misc.*;

public class MidiNoteOffEvent extends MidiEvent
{
  private int pitch;
  private int velocity;
  private int channel;
  
  private MidiNoteOffEvent() {}
  public MidiNoteOffEvent(int channel, int pitch, int velocity,
			  long time)
  {
    this.pitch = pitch;
    this.velocity = velocity;
    this.channel = channel;
    this.time = time;
  }
      
  public void send(MidiOut outDevice)
    throws InvalidMIDIChannelException, NotInitialisedException,
	   MIDIDeviceBusyException
  {
    outDevice.noteOff(channel, pitch, velocity);
  }
}
