/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.midi;


public class MidiDevice
{
  private MidiDevice(){}
  
  public MidiDevice(int manufacturerID, int productID,
		    String name,int voices, int notes,
		    int deviceID)
  {
    this.manufacturerID = manufacturerID; 
    this.productID = productID;
    this.name = name;
    this.voices = voices;
    this.notes = notes;
    this.deviceID = deviceID;
  }
  
  public int getManufacturerID()
  {
    return(manufacturerID);
  }

  public int getProductID()
  {
    return(productID);
  }
  
  public String getName()
  {
    return(new String(name));
  }
  
  public int getNumVoices()
  {
    return(voices);
  }
  
  public int getNumNotes()
  {
    return(notes);
  }
  
  public int getDeviceID()
  {
    return(deviceID);
  }

  
  private int manufacturerID;      
  private int productID;
  private String name;
  private int voices;
  private int notes;
  private int deviceID;
}
