/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.midi;
import herman.misc.*;

public class Midi
{
  private Midi(){};

  // MIDI Status codes
  protected final static int MIDI_NOTEOFF=0x80;
  protected final static int MIDI_NOTEON=0x90;
  protected final static int MIDI_PROGRAMCHANGE=0xC0;



  // error codes returned by low level stuff
  protected final static int MIDI_OK = 0;
  protected final static int MIDI_ALREADYINITIALISED = -1;
  protected final static int MIDI_NOTINITIALISED = -2;
  protected final static int MIDI_FATALERROR = -3;
  protected final static int MIDI_PORTNOTFOUND = -4;
  protected final static int MIDI_DEVICEBUSY = -5;
  protected final static int MIDI_STILLPLAYING = -6;
  protected final static int MIDI_NOTOPENED = -7;
  protected final static int MIDI_BADHANDLE = -8;
  protected final static int MIDI_INVALIDDEVICEID = -9;

  // MIDI devices in the system
  public static MidiDevice[] outDevices = new MidiDevice[0];
  public static MidiDevice[] inDevices = new MidiDevice[0];
  

  // MIDI instruments we know
  public static Object instruments[][] = {{new String("piano"), new Integer(19)},
					  {new String("clarinet"), new Integer(71)},
					  {new String("flute"), new Integer(73)},
					  {new String("trombone"), new Integer(57)},
					  {new String("synthstrings1"), new Integer(50)}};

  public static void init()
    throws AlreadyInitialisedException
  {
    outDevices = MidiOut.init();
  }

  public static void shutdown()
    throws NotInitialisedException
  {
    MidiOut.shutdown();
    outDevices = null;
  }


  public static int translateProgram(String progName)
    throws UnknownInstrumentException
  {
    for(int i=0; i<instruments.length ; i++)
      if (((String) instruments[i][0]).equalsIgnoreCase(progName))
	return((((Integer) instruments[i][1]).intValue()));
    
    throw new UnknownInstrumentException("progName");
  }
}
