/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.mapper.styles;
import herman.elements.Phrase;
import herman.mapper.Mapper;
import herman.form.PhraseForm;

/** 
 * The StyleTemplate class is the super-class for all style templates  
 */

public class StyleTemplate {

/** 
 *  Apply any "between phrase" parameter changes
 */
  public void applyNewPhraseChanges(int i) {
   
  }

/** 
 *  Apply any "between sentence" parameter changes
 */
  public void applyNewSentenceChanges(int i) {
   
  }

/** 
 *  Make parameter changes as needed based on the current tension level 
 */
  public void applyTensionLevel(int i) {
    
  }

  public void applyRhythm(Phrase p, int t) {

  }

/*
 * Check to see if new tension level outside range of lastTension
 */ 
  boolean validTension(int tension, int lastTension) {
    int range = (int)PhraseForm.validTensionRange;

    if ((tension > (lastTension + range))||
	(tension < (lastTension - range))) {
      return false;
    }
    return true;
  }

}
