/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.mapper.styles;
import herman.mapper.Mapper;
import herman.form.*;
import herman.pitch.harmony.*;
import herman.pitch.melody.*;
import herman.pitch.instruments.*;
import herman.elements.*;

/** 
 * The BasicStyle class contains the standard style template  
 */

public class BasicStyle extends StyleTemplate {
  private int lastTension = 0;
  private int lastPhraseTension = 0;
  private boolean forceChange = false;
  private final float BASEuniformity = 30.0f;

  public BasicStyle() {
   
    //Initialize the Melody
    ChordTones.setMaxNonChordTonePercent(0.1f);
    ChordTones.setMinMatchProb(-10.0f);
    float[] prefer = 
    {15.0f,
     20.0f,20.0f,
     15.0f,15.0f,
     10.0f,10.0f,
     8.0f,
     2.0f, 2.0f,
    -3.0f, -3.0f,
    -5.0f,
    -5.0f, -5.0f};
     
    IntervalPreference.setManualPreference(prefer);  
    IntervalHarshness.setHarshness(0.0f);
    Resolution.finality = 0;
    MelodyScale.setFlag(true); 

      //Initialize the harmony
      Cadence.setPhraseResolution(1);
      Cadence.setSentenceResolution(1);
      Cadence.setResolutionFinality(0);
      CommonTones.commonTones = true;
      DissonanceLevel.setDissonanceLevel(1.0f);
      DissonanceHandling.setDissonancePrep(2);
      DissonanceHandling.setDissonanceRes(2);
      GeneralProgression.ignoreLevel = 0.0f;
      KeyControl.setCurrentMode("major");
      KeyControl.setCurrentKeyType(0);
      PivotRules.pivotRules = true;
      SameChordRules.sameChord = true;

      //Intialize the instrumentation
      Instrumentation.setMelodyReg(0);
      Instrumentation.setMelodyCenter(10);
      Instrumentation.setMelodyRange(10,14);
      Instrumentation.setMelodyInstr("flute");
      Instrumentation.setAccompReg(-1);
      Instrumentation.setAccompCenter(10);
      Instrumentation.setAccompInstr("piano");
     
      //Initialize the form
      Labeller.setThreshold(10);
      Contour.uniformity = BASEuniformity;
      Contour.variety = 20.0f;
      PhraseForm.variety = 30.0f;
      PhraseForm.currentTension = 0;
      PhraseForm.validTensionRange = 10;
      int size = SentenceForm.typePoss.length;
      boolean[] type = new boolean[size];
      for (int i = 0; i<type.length; i++) {
	type[i] = true;
      }
      type[0] = false;
      type[2] = false;
      type[4] = true;
      SentenceForm.typePoss = type;    
  }

/** 
 *  Apply any "between phrase" parameter changes
 */
  public void applyNewPhraseChanges(int tension) {
    //Put the rhythm stuff here

    //force changes based on the tension level
    forceChange = true;
    applyTensionLevel(tension);
    forceChange = false;

    //change current key mode to minor above 30
    if ((lastPhraseTension<30)&&(tension >= 30)) {
      KeyControl.setCurrentMode("minor");
      Modulation.stopModulation();
    }
    else if  ((lastPhraseTension>=30)&&(tension < 30)) {
      KeyControl.setCurrentMode("major");
      Modulation.stopModulation();
    }

    //change the instrumentation
    if (tension < 30) {
      Instrumentation.setMelodyInstr("flute");
      Instrumentation.setMelodyReg(0);
    }
    else if (tension < 60) {
      Instrumentation.setMelodyInstr("synthstrings1");
      Instrumentation.setMelodyReg(0);
    }
    else {
      Instrumentation.setMelodyInstr("synthstrings1");
      Instrumentation.setMelodyReg(1);
    }

    lastPhraseTension = tension;
  }

/** 
 *  Apply any "between sentence" parameter changes
 */
  public void applyNewSentenceChanges(int tension) {
   
  }

/** 
 *  Make parameter changes as needed based on the current tension level 
 */
  public void applyTensionLevel(int tension) {
   
    //Only change parameters when necessary or when forced (at end of phrase)
    if (((forceChange)&&(tension != lastTension))||
	(!(validTension(tension,lastTension)))) {
    
      herman.pitch.io.PitchInstInput.ignoreMelody();
      herman.pitch.io.PitchInstInput.ignoreHarmony();

      //change current key mode to minor above 30
      if ((lastTension<30)&&(tension >= 30)) {
	Modulation.setModulation("minor");
      }
      else if  ((lastTension>=30)&&(tension < 30)) {
	Modulation.setModulation("major");
      }

      //Turn off dissonance preparation above 40
      if ((lastTension<40)&&(tension >= 40)) {
	DissonanceHandling.setDissonancePrep(0);
      }
      else if  ((lastTension>=40)&&(tension < 40)) {
	DissonanceHandling.setDissonancePrep(2);
      }

      //Turn off dissonance resolution above 65
      if ((lastTension<65)&&(tension >= 65)) {
	DissonanceHandling.setDissonanceRes(0);
      }
      else if  ((lastTension>=65)&&(tension < 65)) {
	DissonanceHandling.setDissonanceRes(2);
      }

      //Lower validTensionRange above 35
      if ((lastTension<35)&&(tension >= 35)) {
	PhraseForm.validTensionRange = 5;
      }
      else if  ((lastTension>=40)&&(tension < 40)) {
	PhraseForm.validTensionRange = 10;
      }

       //Turn off common Tones above 40
      if ((lastTension<40)&&(tension >= 40)) {
	CommonTones.commonTones = false;
      }
      else if  ((lastTension>=40)&&(tension < 40)) {
	CommonTones.commonTones = true;
      }

      float value = 0.0f;
      //Change the dissonance level
      value = (((float)tension)/100.0f) *70.0f;
      DissonanceLevel.setDissonanceLevel(value);

      //Change the Cadence
      if (tension < 20) {
	Cadence.setPhraseResolution(1);
      } else if (tension < 50) {
	Cadence.setPhraseResolution(2);
      } else if (tension < 65) {
	Cadence.setPhraseResolution(3);
      } else {
	Cadence.setPhraseResolution(4);
      }
      //change resolution finality above 75
      if ((lastTension<75)&&(tension >= 75)) {
	Cadence.setResolutionFinality(1);
      }
      else if  ((lastTension>=75)&&(tension < 75)) {
	Cadence.setResolutionFinality(0);
      }
      
      //Set the chord tones, Interval Preference possibilities
      if (tension < 15) {
	ChordTones.setMaxNonChordTonePercent(30.0f);
	ChordTones.setMinMatchProb(-10.0f);
	float[] prefer = 
	{15.0f,
	 20.0f,20.0f,
	 15.0f,15.0f,
	 10.0f,10.0f,
	 8.0f,
	 2.0f, 2.0f,
        -3.0f, -3.0f,
        -5.0f,
        -5.0f, -5.0f};
	IntervalPreference.setManualPreference(prefer);
      }
      else if (tension < 50) {
	ChordTones.setMaxNonChordTonePercent(40.0f);
	ChordTones.setMinMatchProb(0.0f);
	float[] prefer = 
	{15.0f,
	 20.0f,20.0f,
	 15.0f,15.0f,
	 10.0f,10.0f,
	 8.0f,
	 2.0f, 2.0f,
        -3.0f, -3.0f,
        -5.0f,
        -5.0f, -5.0f};
     
	IntervalPreference.setManualPreference(prefer);
      }
      else if (tension < 65) {
	ChordTones.setMaxNonChordTonePercent(50.0f);
	ChordTones.setMinMatchProb(-10.0f);
	float[] prefer = 
	{15.0f,
	 20.0f,20.0f,
	 15.0f,15.0f,
	 10.0f,10.0f,
	 8.0f,
	 2.0f, 2.0f,
        -3.0f, -3.0f,
        -5.0f,
        -5.0f, -5.0f};
     
	IntervalPreference.setManualPreference(prefer);
      }
      else if (tension < 85) {
	ChordTones.setMaxNonChordTonePercent(60.0f);
	ChordTones.setMinMatchProb(-10.0f);
	float[] prefer = 
	{15.0f,
	 20.0f,20.0f,
	 15.0f,15.0f,
	 10.0f,10.0f,
        -1.0f,
        -1.0f, -1.0f,
        -3.0f, -3.0f,
       - 5.0f,
        -5.0f, -5.0f};
     
	IntervalPreference.setManualPreference(prefer);
      }
      else {
	ChordTones.setMaxNonChordTonePercent(70.0f);
	ChordTones.setMinMatchProb(-10.0f);
	float[] prefer = 
	{5.0f,
	 5.0f,5.0f,
	 -2.0f,-2.0f,
	 -2.0f,-1.0f,
        -3.0f,
        -3.0f, -1.0f,
        -3.0f, -3.0f,
       - 5.0f,
        -5.0f, -5.0f};
     
	IntervalPreference.setManualPreference(prefer);
      }
      
      //Turn off MelodyScale above 85
      if ((lastTension<85)&&(tension >= 85)) {
	MelodyScale.setFlag(false);
      }
      else if  ((lastTension>=40)&&(tension < 40)) {
	MelodyScale.setFlag(true);
      }

      //Change the Interval harshness level
      value = (((float)tension)/100.0f)*90.0f;
      IntervalHarshness.setHarshness(value);

      //Slowly increase the uniformity above tension level 70
      if (tension < 70) {
	Contour.uniformity = BASEuniformity;
      }
      else  {
	value = ((float)(tension - 70))/30.0f*50.0f;
	Contour.uniformity = (BASEuniformity + value);
      }
      
      //Make updates
      lastTension = tension;
      PhraseForm.currentTension = tension;
    }
  }


  public void applyRhythm(Phrase p, int tensionLevel)
  {
    p.rhythmStuff.tensionLevel = tensionLevel;

    /*
    // tension transforms
    if ((tensionLevel > 70) && (p.speedChangeCount < 4) && (Math.random() > 0.5))
    {
      p.rhythmStuff.transformations.addElement(new herman.rhythm.transforms.TempoChangeTransform(0.8));
      p.speedChangeCount++;
    }

    if ((tensionLevel < 30) && (p.speedChangeCount > 0) && (Math.random() > 0.5))
    {
      p.rhythmStuff.transformations.addElement(new herman.rhythm.transforms.TempoChangeTransform(1.2));
      p.speedChangeCount--;
    }
    */

    // velocity transforms
    if ((tensionLevel > 70) && (p.velChangeCount < 4) && (Math.random() > 0.5))
    {
      p.rhythmStuff.transformations.addElement(new herman.rhythm.transforms.VelocityChangeTransform(1.5));
      p.velChangeCount++;
    }

    if ((tensionLevel < 30) && (p.velChangeCount > 0) && (Math.random() > 0.5))
    {
      p.rhythmStuff.transformations.addElement(new herman.rhythm.transforms.VelocityChangeTransform(0.667));
      p.velChangeCount--;
    }
  }
}
