/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.mapper;
import herman.mapper.styles.*;
import herman.elements.Phrase;
import herman.misc.Configuration;

/** 
 * The Mapper class acts as the interface between the graphical interface
 *  and the Music Generator.  
 */

public class Mapper {

  private static StyleTemplate currentStyleTemplate = null;
  private static int currentTension = 0;
  
  public static void initialize() {
    StyleTemplate style = new BasicStyle();
    changeStyleTemplate(style);
    //set the current Tension:

  }

/** 
 *  Apply any "between phrase" parameter changes
 */
  public static void newPhrase() {
    currentStyleTemplate.applyNewPhraseChanges(currentTension);
  }

/** 
 *  Apply any "between sentence" parameter changes
 */
  public static void newSentence() {
    currentStyleTemplate.applyNewSentenceChanges(currentTension);
  }

/** 
 *  Make parameter changes as needed based on the current tension level 
 */
  public static void applyTensionLevel() {
    //NEED TO CHANGE THIS!!!!!!
    currentTension = Configuration.tensionLevel;

    currentStyleTemplate.applyTensionLevel(currentTension);
  }

  public static void applyRhythm(Phrase p) {
    currentStyleTemplate.applyRhythm(p, currentTension);
  }

/** 
 * Chages the current StyleTemplate to the supplied Style Template
 */
  public static void changeStyleTemplate(StyleTemplate style) {
    currentStyleTemplate = style;
    //currentStyleTemplate.initialize();
    applyTensionLevel();
  }

}
