/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.gui;
import com.sun.java.swing.*;
import com.sun.java.swing.table.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.preview.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.preview.filechooser.*;
import com.sun.java.swing.border.*;
import java.io.*;
import herman.misc.*;
import herman.midi.*;
import herman.midiplayer.*;



public class Gui
{
  private static JFrame mainFrame = null;
  private static JLabel tensionSliderVal = null;
  private static JSlider tensionSlider = null;
  private static JDialog configFrame = null;
  public static int deviceSelected = 0;
  private static JComboBox deviceBox = null;
  
  private static MidiOut midiOut;
  private static boolean started = false;
  
  // start the GUI going basically (opens main window)
  public static void init(MidiOut outDevice)
  {
    midiOut = outDevice;

    mainFrame = new JFrame(Configuration.progName);
    
    // workaround for java bug
    mainFrame.setLocation(-1000,-1000);
    mainFrame.show();
    mainFrame.hide();

    mainFrame.setLocation(200,200);
    mainFrame.getContentPane().setLayout(null);
    mainFrame.setSize(255,180);
    mainFrame.setResizable(false);
    mainFrame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
    mainFrame.addWindowListener(new WindowListener()
				{
				  public void windowActivated(WindowEvent e) {}
				  public void windowClosed(WindowEvent e) {}
				  public void windowClosing(WindowEvent e) 
				  {
				    Gui.quitSelected();
				  }
				  public void windowDeactivated(WindowEvent e) {}
				  public void windowIconified(WindowEvent e) {}
				  public void windowDeiconified(WindowEvent e) {}
				  public void windowOpened(WindowEvent e) {}
				});


    JMenuBar tempMenuBar = new JMenuBar();
    JMenu tempMenu = new JMenu("File");

    JMenuItem tempItem = new JMenuItem("Quit");
    tempItem.addActionListener(new ActionListener()
			       {
				 public void actionPerformed(ActionEvent e)
				 {
				   Gui.quitSelected();
				 }});
    tempMenu.add(tempItem);
    tempMenuBar.add(tempMenu);


    tempMenu = new JMenu("Help");
    tempItem = new JMenuItem("About...");
    tempItem.addActionListener(new ActionListener()
			       {
				 public void actionPerformed(ActionEvent e)
				 {
				   Gui.aboutSelected();
				 }});
    tempMenu.add(tempItem);
    tempMenuBar.add(tempMenu);
    mainFrame.setJMenuBar(tempMenuBar);


    JPanel tempPanel = new JPanel();
    tempPanel.setBorder(new TitledBorder("Tension level"));
    tempPanel.setLayout(null);
    tempPanel.setBounds(10,10,230,50);
    tensionSlider= new JSlider(JSlider.HORIZONTAL, 0, 99, 
			       Configuration.tensionLevel);
    tensionSlider.setPaintTicks(true);
    tensionSlider.setSnapToTicks(true);
    tensionSlider.setMinorTickSpacing(1);
    tensionSlider.addChangeListener(new ChangeListener()
				 {
				   public void stateChanged(ChangeEvent e)
				   {
				     JSlider s = (JSlider)e.getSource();
				     tensionSliderVal.setText(""+s.getValue());

				     // update tension level in rest of system
				     Configuration.tensionLevel = s.getValue();
				   }});
    tensionSlider.setBounds(10,15,200,30);
    tempPanel.add(tensionSlider);
    tensionSliderVal = new JLabel("XX");
    tensionSliderVal.setHorizontalAlignment(JLabel.CENTER);
    tensionSliderVal.setText("" + tensionSlider.getValue());
    tensionSliderVal.setBounds(205,10,25,25);
    tempPanel.add(tensionSliderVal);
    mainFrame.getContentPane().add(tempPanel);

    JButton tempButton = new JButton("Boo!");
    tempButton.setLocation(10, 70);
    tempButton.setSize(230,25);
    tempButton.addMouseListener(new MouseListener()
				 {
				   public void mouseClicked(MouseEvent e)
				   {
				     if (e.getID() == MouseEvent.MOUSE_CLICKED)
				       Gui.surpriseSelected();
				   }

				   public void mouseEntered(MouseEvent e){}
				   public void mouseExited(MouseEvent e){}
				   public void mousePressed(MouseEvent e){}
				   public void mouseReleased(MouseEvent e){}
				 });

    mainFrame.getContentPane().add(tempButton);


    tempButton = new JButton("Start");
    tempButton.setLocation(10, 100);
    tempButton.setSize(80,25);
    tempButton.addMouseListener(new MouseListener()
				 {
				   public void mouseClicked(MouseEvent e)
				   {
				     if (e.getID() == MouseEvent.MOUSE_CLICKED)
				       Gui.startPlaying();
				   }

				   public void mouseEntered(MouseEvent e){}
				   public void mouseExited(MouseEvent e){}
				   public void mousePressed(MouseEvent e){}
				   public void mouseReleased(MouseEvent e){}
				 });

    mainFrame.getContentPane().add(tempButton);


    mainFrame.show();
    mainFrame.repaint();
  }





  // select all tracks button selected
  private static void surpriseSelected()
  {
    // do something!
  }


  private static void startPlaying()
  {
    if (!started)
    {
      MidiPlayer.init(midiOut);	
      started = true;
    }
  }


  // configuration window selected
  public static int showConfig()
  {
    configFrame = new JDialog(mainFrame, "MIDI device", true);
    configFrame.getContentPane().setLayout(null);
    configFrame.setSize(250,230);
    configFrame.setResizable(false);
    configFrame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
    configFrame.setLocationRelativeTo(mainFrame);
    
    JPanel tempPanel = new JPanel();
    tempPanel.setBorder(new TitledBorder("Choose device"));
    tempPanel.setLayout(null);
    tempPanel.setSize(230,50);
    tempPanel.setLocation(10,60);
    deviceBox = new JComboBox(Configuration.midiDevices);
    deviceBox.setEditable(false);
    deviceBox.setSelectedItem(Configuration.midiDevices[0]);
    deviceBox.setSize(210,25);
    deviceBox.setLocation(10,15);
    tempPanel.add(deviceBox);
    configFrame.getContentPane().add(tempPanel);


    tempPanel = new JPanel();
    tempPanel.setLayout(null);
    tempPanel.setSize(230,50);
    tempPanel.setLocation(10,160);
    JButton tempButton = new JButton("OK");
    tempButton.setSize(100,25);
    tempButton.setLocation(65,10);
    tempButton.addMouseListener(new MouseListener()
				 {
				   public void mouseClicked(MouseEvent e)
				   {
				     if (e.getID() == MouseEvent.MOUSE_CLICKED)
				       Gui.okConfig();
				   }

				   public void mouseEntered(MouseEvent e){}
				   public void mouseExited(MouseEvent e){}
				   public void mousePressed(MouseEvent e){}
				   public void mouseReleased(MouseEvent e){}
				 });
    tempPanel.add(tempButton);
    configFrame.getContentPane().add(tempPanel);

    configFrame.show();

    return(deviceSelected);
  }

  private static void okConfig()
  {
    deviceSelected = deviceBox.getSelectedIndex();
    Gui.configFrame.dispose();
    configFrame = null;
  }



  // when quit is selected
  private static void quitSelected()
  {
    String[] poo = {"Are you sure you want to quit?"};
    if (JOptionPane.showConfirmDialog(mainFrame, poo, "Quit?",
				      JOptionPane.YES_NO_OPTION) ==
	JOptionPane.NO_OPTION)
      return;
    
    System.exit(1);
  }


  // stuff for the About window
  private static void aboutSelected()
  {
    String[] poo = {Configuration.progName , "Version " + 
		    Configuration.version};
    JOptionPane.showMessageDialog(mainFrame, poo, "About", 
				  JOptionPane.INFORMATION_MESSAGE);
  }
}
