/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.types;
import herman.elements.Phrase;
/**
 *  The Variation sentence form
 */

public class VariationForm extends SentenceType {
  private static int size = 0;
  private static int originalKeyType = 0;
  
/** 
 * Returns the PhraseType[] that characterizes the Variation form.
 * <p>
 * A A' A'' ... B
 */
  public PhraseType[] getSentenceType() {
    //Randomly determine # of variations
    size = 0;
    float rand = ((float)java.lang.Math.random());
    if (rand <= 0.33f) size = 3;
    else if (rand <= 0.66f) size = 4;
    else size = 5;

    PhraseType[] sentence = new PhraseType[size];
    
    sentence[0] = new PhraseType(0,false);
    for (int i =1; i < (size - 1); i++) {
      sentence[i] = new PhraseType(0,true); 
    }
    sentence[(size - 1)] = new PhraseType(1,false);
    
    return sentence;
  }

  public void applyPhraseTransformations(Phrase phrase, int position) {
    //Transformations occur for phrases other than the last
    System.out.println("The position is .." + position);
    if (position < size) {
      float rand = ((float)java.lang.Math.random());
      float first = 0.33f;
      float second = 0.66f;
      float third = 100.0f;
      
      //40% of the time, shift the key
      if (rand <= 0.2f) {
	shiftCurrentKeyUpFifth();

	//Reset the dividers for transformations
	first = 0.25f;
	second = 0.50f;
	third = 0.75f;
      } else if (rand <= 0.4f) {
	shiftCurrentKeyDownFifth();
	
	//Reset the dividers for transformations
	first = 0.25f;
	second = 0.50f;
	third = 0.75f;
      }
    
      //Decide what other transformations, if any
      rand = ((float)java.lang.Math.random());
      
      //some of the time, clear the harmony
      if (rand <= first) {
	clearHarmony(phrase);
	System.out.println("Transformation to clear harmony");
      }

      //some of the time, clear the melody
      else if (rand <= second) {
	clearMelody(phrase);
      }

      //some of the time, transpose the melody
       else if (rand <= third) {
	transposeMelody(phrase);
	clearHarmony(phrase);
       }
    }
  }

  public void applyPhrasePositionRules(int position) {
    //Set the original key 
    if (position == 0) {
      originalKeyType = herman.pitch.harmony.KeyControl.getIntCurrentKeyType();
    }

    //restore the original key at the end
    else if (position == size) {
      setCurrentKey(originalKeyType);
    }
  }

}
