/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.types;
import herman.elements.*;


/**
 *  The Ternary sentence form
 */

public class TernaryForm extends SentenceType {
  private static int keyShift = 0;
  private static boolean shiftKey = false;

/** 
 * Returns the PhraseType[] that characterizes the Ternary form.
 * <p>
 * A B A(')
 */
  public PhraseType[] getSentenceType() {
    PhraseType[] sentence = {new PhraseType(0,false),
                             new PhraseType(1,false),
                             new PhraseType(0,false)};

    //Randomly use transformations
    float rand = ((float)java.lang.Math.random());
    if (rand <= 0.5f) {
      sentence[2].transformation = true;
    }

    //Randomly use key shifts for B phrase 75% of the time
    rand = ((float)java.lang.Math.random());
    if (rand <= 0.75f) {
      shiftKey = true;
    }

    return sentence;
  }

  public void applyPhrasePositionRules(int position) {
    //Change keys for the B phrase
    if ((position == 1)&&(shiftKey)) {
      float rand = ((float)java.lang.Math.random());
      
      if (rand <= 0.5f) {
	shiftCurrentKeyUpFifth();
	keyShift = 1;
      } else {
	shiftCurrentKeyDownFifth();
	keyShift = 0;
      }
    }
    
    else if ((position == 2)&&(shiftKey)) {
      
      if (keyShift == 1) {  //key was shifted up a fifth, so shift back
	shiftCurrentKeyDownFifth();
      }
      else {               //key was shifted down a fifth, so shift back
	shiftCurrentKeyUpFifth();
      }
    }
  }


}
