/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.types;
import herman.elements.Phrase;
import herman.pitch.harmony.KeyControl;
import herman.properties.*;
import herman.form.transforms.*;
import herman.pitch.melody.IntervalPreference;
import herman.pitch.tools.*;

/**
 *  The SentenceType class is the super-class for all sentence types
 */

public class SentenceType {

/** 
 * Applies any phrase position rules
 */
  public void applyPhrasePositionRules(int position) {

  }

/** 
 * Applies any phrase transformations based on phrase position
 */
  public void applyPhraseTransformations(Phrase phrase, int position) {

  }

/** 
 * Returns the PhraseType[] that characterizes the sentence type.
 * <p>
 *
 */
  public PhraseType[] getSentenceType() {
    PhraseType[] pt = new PhraseType[1];
    System.out.println("Doing the worng sentence type thingy");
    return pt;
  }

/* 
 * Clears  the melody
 */
  static void clearMelody(Phrase phrase) {
    MelodyClearAll mca = new MelodyClearAll();
    phrase.transformation.addTransform(mca);
    phrase.transformation.setStatus("transform");
  }

/* 
 * Clears  the melody pitches
 */
  static void clearMelodyPitches(Phrase phrase) {
    MelodyClearPitch mcp = new MelodyClearPitch();
    phrase.transformation.addTransform(mcp);
    phrase.transformation.setStatus("transform");
  }

/* 
 * Clears the melody pitches
 */
  static void transposeMelody(Phrase phrase) {
    float[] prefer = IntervalPreference.getCurrentPreferences();
    int select = 0;

    while ((select!=0)&&(select<12)) {
     select = ArrayTools.probableSelect(prefer);
    }
    
    float rand = ((float)java.lang.Math.random());
   
    //Randomly decide direction of transpose
    if (rand <= 0.50f) {
      select = 0 - select;
    }

    Interval interval = new Interval(select);

    MelodyTranspose mt = new MelodyTranspose(interval);
    phrase.transformation.addTransform(mt);
    phrase.transformation.setStatus("transform");
  }

/* 
 * Clears the harmony
 */
  static void clearHarmony(Phrase phrase) {
    HarmonyClearAll hca = new HarmonyClearAll();
    phrase.transformation.addTransform(hca);
    phrase.transformation.setStatus("transform");
  }

 /* 
 * shifts the current key up a fifth
 */
  static void shiftCurrentKeyUpFifth() {
    int curKeyType = KeyControl.getIntCurrentKeyType();
    curKeyType = curKeyType + 7;
    KeyControl.setCurrentKeyType(curKeyType);
  }

/* 
 * shifts the current key down a fifth
 */
  static void shiftCurrentKeyDownFifth() {
    int curKeyType = KeyControl.getIntCurrentKeyType();
    curKeyType = curKeyType - 7;
    KeyControl.setCurrentKeyType(curKeyType);
  }   

 /* 
 * sets the current key to the supplied key type
 */
  static void setCurrentKey(int key) {
    KeyControl.setCurrentKeyType(key);
  }    
}
    
