/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.types;

/**
 *  The RoundedBinary sentence form
 */

public class RoundedBinaryForm extends SentenceType {

/** 
 * Returns the PhraseType[] that characterizes the Rounded Binary form.
 * <p>
 * A A B A(') B A(')
 */
  public PhraseType[] getSentenceType() {
    PhraseType[] sentence = 
      {new PhraseType(0,false),
       new PhraseType(0,false),
       new PhraseType(1,false),
       new PhraseType(0,false),
       new PhraseType(1,false),
       new PhraseType(0,false)};
    
    //Randomly use transformations
    float rand = ((float)java.lang.Math.random());
    if (rand <= 0.5f) {
      sentence[3].transformation = true;
      sentence[5].transformation = true;
    }

    return sentence;
  }
}
