/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.types;
import herman.elements.Phrase;
/**
 *  The Rondo sentence form
 */

public class RondoForm extends SentenceType {

/** 
 * Returns the PhraseType[] that characterizes the Rondo form.
 * <p>
 * A B A C A B' A
 */
  public PhraseType[] getSentenceType() {
    PhraseType[] sentence = {new PhraseType(0,false),
                             new PhraseType(1,false),
                             new PhraseType(0,false),
                             new PhraseType(2,false),
                             new PhraseType(0,false),
                             new PhraseType(1,true),
                             new PhraseType(0,false)};
    
    return sentence;
  }

  public void applyPhraseTransformations(Phrase phrase, int position) {
    //Transformations occur for the second B phrase
    if (position == 5) {
      float first = 0.33f;
      float second = 0.66f;
      float third = 100.0f;
    
      //Decide what other transformations, if any
      float rand = ((float)java.lang.Math.random());
      
      //some of the time, clear the harmony
      if (rand <= first) {
	clearHarmony(phrase);
      }

      //some of the time, clear the melody
      else if (rand <= second) {
	clearMelody(phrase);
      }

      //some of the time, transpose the melody
       else if (rand <= third) {
	transposeMelody(phrase);
	clearHarmony(phrase);
       }
    }
  }
}
