/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.types;

/**
 *  The Rondeau sentence form
 */

public class RondeauForm extends SentenceType {
  private static int keyShift = 0;
  private static boolean shiftKey = true;


/** 
 * Returns the PhraseType[] that characterizes the Rondeau form.
 * <p>
 * A B A C A D A
 */
  public PhraseType[] getSentenceType() {
    PhraseType[] sentence = {new PhraseType(0,false),
                             new PhraseType(1,false),
                             new PhraseType(0,false),
                             new PhraseType(2,false),
                             new PhraseType(0,false),
                             new PhraseType(3,false),
                             new PhraseType(0,false)};
    
    keyShift = 0;
    return sentence;
  }

  public void applyPhrasePositionRules(int position) {
    //Change keys for the B, C, & D phrases
    if ((position == 1)&&(shiftKey)) {
      float rand = ((float)java.lang.Math.random());
      
      if (rand <= 0.5f) {
	shiftCurrentKeyUpFifth();
	keyShift = 1;
      } else {
	shiftCurrentKeyDownFifth();
	keyShift = 0;
      }
    }
    
    else if (((position == 2)||(position==4)||(position==6))&&(shiftKey)) {
      
      if (keyShift == 1) {  //key was shifted up a fifth, so shift back
	shiftCurrentKeyDownFifth();
      }
      else {               //key was shifted down a fifth, so shift back
	shiftCurrentKeyUpFifth();
      }
    }

    else if ((position == 3)&&(shiftKey)) {
      
      if (keyShift == 1) {  //key was shifted up a fifth, so shift down
	shiftCurrentKeyDownFifth();
	keyShift = 0;
      }
      else {               //key was shifted down a fifth, so shift up
	shiftCurrentKeyUpFifth();
	keyShift = 1;
      }
    }

    else if ((position == 5)&&(shiftKey)) {
      
      if (keyShift == 1) {  //key was shifted up a fifth, so shift down
	shiftCurrentKeyDownFifth();
	keyShift = 0;
      }
      else {               //key was shifted down a fifth, so shift up
	shiftCurrentKeyUpFifth();
	keyShift = 1;
      }
    }
  }

}
