/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.transforms;
import herman.elements.*;
import herman.properties.*;
import herman.pitch.melody.MelodyScale;
import herman.pitch.instruments.*;
import java.util.Enumeration;


/**
 * The MelodyTranspose class shifts the pitch of each melodic event in
 * the phrase by the specified interval.  MelodyTranspose shifts each pitch
 * by the <em>exact<\em> amount of the interval, even if the resulting pitch
 * is not a valid scale tone in the key.  The event will be moved to a valid 
 * scale tone by the Pitch Instantiator: Melody module later if necessary.
 */
 
public class MelodyTranspose extends PhraseTransform {
  private Interval interval = null;

  public MelodyTranspose(Interval i) {
    interval = i;
  }

  public void applyTransform(Phrase phrase) {
    Enumeration egEnum = phrase.partMelEventGroup.getElements();
    Enumeration eventEnum = null;
    EventGroup eg = null;
    Event event = null;
    Pitch newPitch = null;
    System.out.println("TRANSPOSING MELODY");
    

    while(egEnum.hasMoreElements()) {
      eg = (EventGroup)egEnum.nextElement();
      eventEnum = eg.partMelEvent.getElements();
      while (eventEnum.hasMoreElements()) {
	event = (Event)eventEnum.nextElement();

	//Get the transposed pitch
	newPitch = PitchTools.add(event.pitch, interval);

	//Reset the relative pitch
	event.pitch.setRelPitch(newPitch.getRelPitch());
      }
    }
  }
  
}
