/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.transforms;
import herman.elements.*;
import herman.properties.*;
import herman.pitch.melody.MelodyScale;
import herman.pitch.instruments.*;
import java.util.Enumeration;


/**
 * The MelodyDirectKeyShift class moves each melodic event to the
 * pitch in the same scale position relative to the tonic tone of the
 * new key, either a fifth above or a fifth below (as
 * specified) the current key.
 */
 
public class MelodyDirectKeyShift extends PhraseTransform {
  private StringBuffer direction = new StringBuffer();

  public MelodyDirectKeyShift(String dir) {
    direction.insert(0,dir);
    direction.setLength(dir.length());
  }

  public void applyTransform(Phrase phrase) {
    Enumeration egEnum = phrase.partMelEventGroup.getElements();
    Enumeration eventEnum = null;
    EventGroup eg = null;
    Event event = null;
    int kp = 0;
    int tonic = 0;
    int currentKeyType = -100;
    System.out.println("SHIFTING MELODY KEY");
   

    while(egEnum.hasMoreElements()) {
      eg = (EventGroup)egEnum.nextElement();
      eventEnum = eg.partMelEvent.getElements();
      while (eventEnum.hasMoreElements()) {
	event = (Event)eventEnum.nextElement();
	kp = MelodyScale.getKeyPitch(event).getKeyPitch();

	//if this is a new key for the phrase
	if (event.key.getIntKeyType() != currentKeyType) {
	  //set currentKeyType
	  currentKeyType = event.key.getIntKeyType();
	  
	  //Reset the tonic
	  tonic = currentKeyType % 12;  
	  if (tonic < 0) tonic = tonic + 12;

	  //Center the tonic about the melody center
	  int center = Instrumentation.getIntMelodyCenter();
	  if (tonic < (center - 5)) {tonic = tonic + 12;}
	  else if (tonic > (center + 6)) {tonic = tonic - 12;} 
	}

	//Reset the event key information
	if (direction.toString().equals("up")) {
	  event.key.setKeyType((currentKeyType + 7));   //Up a P5
	} else if (direction.toString().equals("down")) {
	  event.key.setKeyType((currentKeyType - 7));   //Down a P5
	}

	event.pitch.setRelPitch((tonic + kp));
      }
    }
  }
  
}
