/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.transforms;
import herman.elements.*;
import herman.properties.*;
import herman.pitch.melody.MelodyScale;
import herman.pitch.instruments.*;
import java.util.Enumeration;


/**
 * The MelodyDirectKeyChange class moves each melodic event to the
 * pitch in the same scale position relative to the tonic tone of the
 * specified key.
 */
 
public class MelodyDirectKeyChange extends PhraseTransform {
  private Key key = null;

  public MelodyDirectKeyChange(Key k) {
    key = k;
  }

  public void applyTransform(Phrase phrase) {
    Enumeration egEnum = phrase.partMelEventGroup.getElements();
    Enumeration eventEnum = null;
    EventGroup eg = null;
    Event event = null;
    int kp = 0;
    int tonic = 0;
    System.out.println("CHANGING MELODY KEY");
    
    //Reset the tonic
    tonic = key.getIntKeyType() % 12;  
    if (tonic < 0) tonic = tonic + 12;
    
    //Center the tonic about the melody center
    int center = Instrumentation.getIntMelodyCenter();
    if (tonic < (center - 5)) {tonic = tonic + 12;}
    else if (tonic > (center + 6)) {tonic = tonic - 12;} 

    while(egEnum.hasMoreElements()) {
      eg = (EventGroup)egEnum.nextElement();
      eventEnum = eg.partMelEvent.getElements();
      while (eventEnum.hasMoreElements()) {
	event = (Event)eventEnum.nextElement();
	kp = MelodyScale.getKeyPitch(event).getKeyPitch();
	
	//Reset the event key information
	event.key.setKeyType(key.getIntKeyType()); 
	
	//Reset the relative pitch
	event.pitch.setRelPitch((tonic + kp));
      }
    }
  }
  
}
