/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.transforms;
import herman.elements.*;
import herman.properties.*;
import java.util.Enumeration;


/**
 * The MelodyClearResolution class clears the pitches and contour from the
 *  events associated with the last two event groups in the phrase.  This
 *  should be the last two chords, but haven't figured out how to clone
 *  Chord.partMelEvent correctly
 */
 
public class MelodyClearResolution extends PhraseTransform {
  public void applyTransform(Phrase phrase) {
    Enumeration melEnum = null;
    Event event = null;

    System.out.println("CLEARING MELODY RESOLUTION");
    int size = phrase.partChord.size();
    Chord chord = null;

    if (size > 1) {
      for (int i = (size - 2); i < size; i++) {
	chord = (Chord)phrase.partChord.getElemAt(i);

	//Enumeration of the events associated with this chord
	melEnum = chord.partMelEvent.getElements();

	while (melEnum.hasMoreElements()) {
	  event = (Event)melEnum.nextElement();
	  event.pitch = new Pitch();        //Clear the pitch
	  event.eventInfo.setSecond(" ");   //Clear the contour
	  // System.out.println("Event key: "+event.key);
	  //event.key = new Key();
	}
      }
    }
  }
  
}
