/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.transforms;
import herman.elements.*;
import herman.properties.*;
import java.util.Enumeration;


/**
 * The MelodyClearAll class clears the pitches and contour of the phrase 
 *  melody events 
 */
 
public class MelodyClearAll extends PhraseTransform {
  public void applyTransform(Phrase phrase) {
    Enumeration egEnum = phrase.partMelEventGroup.getElements();
    Enumeration eventEnum = null;
    EventGroup eg = null;
    Event event = null;
    System.out.println("CLEARING ALL MELODY");

    while(egEnum.hasMoreElements()) {
      eg = (EventGroup)egEnum.nextElement();
      eventEnum = eg.partMelEvent.getElements();
      while (eventEnum.hasMoreElements()) {
	event = (Event)eventEnum.nextElement();
	event.pitch = new Pitch();
	event.key = new Key();
	event.eventInfo.setSecond(" ");    //Clears the contour
      }					 
    }
  }
  
}
