/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.transforms;
import herman.elements.*;
import herman.properties.*;
import java.util.Enumeration;


/** 
 * The HarmonyKeyShift class shifts the key of each chord in the phrase either
 *  up a perfect fifth or down a perfect fifth, as specified
 */
 
public class HarmonyKeyShift extends PhraseTransform {
  private StringBuffer direction = new StringBuffer();

  public HarmonyKeyShift(String dir) {
    direction.insert(0,dir);
    direction.setLength(dir.length());
  }

  public void applyTransform(Phrase phrase) {
    Enumeration chordEnum = phrase.partChord.getElements();
    Chord chord = null;
    System.out.println("SHIFTING KEY OF HARMONY");

    while(chordEnum.hasMoreElements()) {
      chord = (Chord)chordEnum.nextElement();
      int currentKeyType = chord.key.getIntKeyType();

      if (direction.toString().equals("up")) {
	chord.key.setKeyType((currentKeyType + 7));   //Up a P5
      } else if (direction.toString().equals("down")) {
	chord.key.setKeyType((currentKeyType - 7));   //Down a P5
      }
    }
  }
  
}
