/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.transforms;
import herman.elements.*;
import herman.properties.*;
import java.util.Enumeration;


/** 
 * The HarmonyKeyChange class changes the key type of each chord in the phrase
 * to the specified key type.  Mode is unaffected.
 */
 
public class HarmonyKeyChange extends PhraseTransform {
  private Key key = null;

  public HarmonyKeyChange(Key k) {
    key = k;
  }

  public void applyTransform(Phrase phrase) {
    Enumeration chordEnum = phrase.partChord.getElements();
    Chord chord = null;
    System.out.println("CHANGING KEY OF HARMONY");

    while(chordEnum.hasMoreElements()) {
      chord = (Chord)chordEnum.nextElement();
      int keyType = key.getIntKeyType();

      chord.key.setKeyType(keyType);
    }
  }
  
}
