/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.transforms;
import herman.elements.*;
import herman.properties.*;
import java.util.Enumeration;


/** 
 * The HarmonyClearResolution class clears the chord type of the last two 
 * chords
 *  in the phrase, allowing for a new resolution
 */
 
public class HarmonyClearResolution extends PhraseTransform {
  public void applyTransform(Phrase phrase) {
    int size = phrase.partChord.size();
    Chord chord = null;

    System.out.println("CLEARING HARMONY RESOLUTION");
    if (size > 1) {
      for (int i = (size - 2); i < size; i++) {
	chord = (Chord)phrase.partChord.getElemAt(i);
	chord.chordType = new ChordType();
	//chord.key = new Key();
      }
    }
  }
  
}
