/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form.transforms;
import herman.elements.*;
import herman.properties.*;
import java.util.Enumeration;


/**
 * The HarmonyClearAll class clears the chord types and key(s) of the phrase 
 */
 
public class HarmonyClearAll extends PhraseTransform{
  public void applyTransform(Phrase phrase) {
    Enumeration chordEnum = phrase.partChord.getElements();
    Chord chord = null;
    System.out.println("CLEARING ALL HARMONY");

    while(chordEnum.hasMoreElements()) {
      chord = (Chord)chordEnum.nextElement();
      chord.chordType = new ChordType();
      chord.key = new Key();
    }
  }
  
}
