/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form;
import herman.elements.*;
import herman.properties.*;
import herman.rhythm.Rhythm;
import java.util.Enumeration;
import herman.form.transforms.*;


/** 
 * The Transformer transforms the phrases as directed.
 */
 
public class Transformer {
 
/**  
 * Apply the transformation instructions attached to the phrase and send it 
 * the Rhythm module.
 */
  public static void process(Phrase phrase) {
    //Apply Instructions
  
    applyTransforms(phrase);

    //Send to the Rhythm
    Rhythm.add(phrase);
    
    //System.out.println(phrase.phraseInfo.getLocation());
    //System.out.println(phrase.transformation.getStatus());
  }

/* 
 * Calls the transforms
 */
  private static void applyTransforms(Phrase phrase) {
    Enumeration transformEnum = phrase.transformation.transformElements();
    
    while(transformEnum.hasMoreElements()) {
      ((PhraseTransform)transformEnum.nextElement()).applyTransform(phrase);
    }
  }
}
