/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form;
import herman.elements.*;
import herman.properties.*;
import herman.form.types.*;
import java.util.Vector;

/** 
 * The SentenceForm class plans the basic form of each sentence.
 */
 
public class SentenceForm {
  private static Vector sentenceTypes = new Vector();
  private static Vector sentenceTypeReference = new Vector();

  public static SentenceType currentSentenceType = null;

  /** 
   *  An array of booleans indicating which sentence types are possible
   */
  public static boolean[] typePoss = new boolean[9];

/** 
 * Initializes the SentenceForm module
 */
  public static void initialize() {
    //Start with all types possible
    for (int i = 0; i<typePoss.length; i++) {
      typePoss[i] = true;
    }
    typePoss[0] = false;
    typePoss[2] = false;
    typePoss[4] = false;

    SentenceType[] sent = { new SingleType(), new BinaryForm(),
			    new RoundedBinaryForm(), new TernaryForm(),
			    new VariationForm(), new FivePartForm(),
			    new RondoForm(), new RondeauForm(),
			    new SonataForm()};

    for (int i = 0; i<sent.length; i++) {
      sentenceTypeReference.addElement(sent[i]);
    }
    
    /* Add the sentence forms
     *sentenceTypes.addElement(SingleType.getSentenceType());
     *sentenceTypes.addElement(BinaryForm.getSentenceType());
     *sentenceTypes.addElement(RoundedBinaryForm.getSentenceType());
     *sentenceTypes.addElement(TernaryForm.getSentenceType());
     *sentenceTypes.addElement(VariationForm.getSentenceType());
     *sentenceTypes.addElement(FivePartForm.getSentenceType());
     *sentenceTypes.addElement(RondoForm.getSentenceType());
     *sentenceTypes.addElement(RondeauForm.getSentenceType());
     *sentenceTypes.addElement(SonataForm.getSentenceType());
     */
    
  }

  public static PhraseType[] getNewSentence() {
    //here, should decide if new or old sentence.  if old, pass back

    //here should determine the size of new sentence
    PhraseType[] sentence = getSentence();

    //Temporary hack !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    //changePitchSettings();
   
    return sentence;
  }

  /*
   *  Choose a sentence from the sentence types
   */
  private static PhraseType[] getSentence() {
    PhraseType[] sentence = new PhraseType[5];
    
    float rand = 0.0f;    
    int index = 0;

    boolean noSelection = true;
    while (noSelection) {                       //Continue until selection
	//make a random type selection
	rand = ((float)java.lang.Math.random());
	rand = rand * ((float)typePoss.length);
	for (int i = 0; i< typePoss.length; i++) {
	if ((rand <= ((float)i + 1.0f))&&(rand > (float)i)) { 
	  //if that type possible...
	  if (typePoss[i]) {
	    index = i;
	    noSelection = false;
	  }
	}
      }
    }

    System.out.println("Selected sentence type " + index);
    // sentence = (PhraseType[])sentenceTypes.elementAt(index);

    //Set the currentSentenceType
    
    currentSentenceType = (SentenceType)sentenceTypeReference.elementAt(index);

    //get the PhraseType[] for that sentence
    sentence = currentSentenceType.getSentenceType();
    return sentence;
  }

  private static void changePitchSettings() {

    float rand = ((float)java.lang.Math.random());
    int numSet = herman.pitch.io.FixedPitchSettings.numOfSettings;
    rand = rand * ((float)numSet);
    for (int i = 0; i < numSet; i++) {
	if ((rand <= ((float)i + 1.0f))&&(rand > (float)i)) { 
	  herman.pitch.io.FixedPitchSettings.apply(i);
	}
    } 

    //herman.pitch.io.FixedPitchSettings.apply(2);
  }

}



