/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form;
import herman.elements.*;
import herman.properties.*;
import java.util.Vector;

/** 
 * The PhraseLibrary stores old phrases
 */
 
public class PhraseLibrary {
  private static Vector newPhrases = new Vector();
  private static Vector oldPhrases = new Vector();
  private static Vector borrowedPhrases = new Vector();
  private static Vector validPhrases = new Vector();

  private static final int MAXnewPHRASES = 20;
  private static final int MAXoldPHRASES = 20;

/** 
 * Store a phrase in the library
 */
  public static void storePhrase(Phrase phrase) {
    if (phrase.transformation.getStatus().equals("new")) {
      newPhrases.addElement(phrase);
      if (newPhrases.size() > MAXnewPHRASES) {
	newPhrases.removeElementAt(0);
      }
    }
    else {
      oldPhrases.addElement(phrase);
      if (oldPhrases.size() > MAXoldPHRASES) {
	clearOldPhrases();
      }
    }
  }

/** 
 * Get an original phrase (ie, an un-transformed phrase) from the library.
 *  At the moment, this actually <em> removes <\em> the phrase from the
 *  library, so that it can't be picked again during the current sentence.
 */
  public static Phrase getOrigPhrase() {
    float rand = ((float)java.lang.Math.random());
    Phrase phrase = null;
    validPhrases.removeAllElements();

    for (int i = 0; i<newPhrases.size(); i++) {
      phrase = ((Phrase)newPhrases.elementAt(i));
      if (validTension(phrase.tension)) {
	validPhrases.addElement(phrase);
	newPhrases.removeElementAt(i);
      }
    }
    
    for (int i = 0; i<validPhrases.size(); i++) {
      float j  = (float) i;
      if (rand <= ((j+1.0f)/((float)validPhrases.size()))) {
	phrase = ((Phrase)((Phrase)validPhrases.elementAt(i)).clone());
	// Need to recreate upwards associations?????
	
	//remove the phrase temporarily
	borrowedPhrases.addElement((Phrase)validPhrases.elementAt(i));
	validPhrases.removeElementAt(i);
      }
    }

    //Replace the valid phrases in newPhrases
    for (int i = 0; i<validPhrases.size(); i++) {
      newPhrases.addElement(validPhrases.elementAt(i));
    }

    return phrase;
  }

/** 
 *  Replaces phrase borrowed during the current sentence
 */
  public static void replacePhrases() {
    if (borrowedPhrases.size() > 0) {
      for (int i = 0; i<borrowedPhrases.size(); i++) { 
	newPhrases.addElement(borrowedPhrases.elementAt(i));
      }
    }
  }

/** 
 * Returns true if the library has phrases in it
 */
  public static boolean hasPhrases() {
    Phrase phrase = null;
    boolean foundValid = false;

    if (newPhrases.size() > 0) {
      for (int i = 0; i<newPhrases.size(); i++) {
	phrase = ((Phrase)newPhrases.elementAt(i));
	if (validTension(phrase.tension)) {
	  foundValid = true;
	}
      }
      
      if (foundValid) {
	return true;
      }
    }

    return false;
  }

  
  private static boolean validTension(long tension) {
   if ((tension > (PhraseForm.currentTension + PhraseForm.validTensionRange))||
     (tension < (PhraseForm.currentTension - PhraseForm.validTensionRange))) {
     return false;}
   return true;
  }

  private static void clearOldPhrases() {
    //Later, check first phrase to see what sentence references it, and
    // remove that sentence from the SentenceLibrary.
    
    oldPhrases.removeElementAt(0);
    //Then go through and remove all phrases that reference the removed
    // sentence.

  }

  public static void main(String[] args) {
    Phrase phrase1 = new Phrase();
    EventGroup eg1 = new EventGroup();
    Chord chord1 = new Chord();
    Event acc1 = new Event();
    Event event1 = new Event();
    Event event2 = new Event();
    event1.pitch.setRelPitch(5);

    eg1.partMelEvent.addElem(event1);
    eg1.partMelEvent.addElem(event2);

    chord1.partAccompEvent.addElem(acc1);
 
    phrase1.partMelEventGroup.addElem(eg1);
    phrase1.partMelEventGroup.addElem(chord1);
    phrase1.phraseInfo.setLocation("sentence start");
    phrase1.transformation.setStatus("new");

    System.out.println("Storing...");
    storePhrase(phrase1);

    System.out.println("Cloning...");
    Phrase phrase2 = getOrigPhrase();
    
    System.out.println(event1.pitch.isNull());
    System.out.println(phrase2.phraseInfo.getLocation());
    EventGroup eg2 = (EventGroup)phrase2.partMelEventGroup.getFirst();
    Event ev2 = (Event)eg2.partMelEvent.getElemAt(1);
    Event ev1 = (Event)eg2.partMelEvent.getElemAt(0);
    ev2.pitch.setRelPitch(10);
    
    System.out.println("Clone event2 has pitch = "+ev2.pitch);
    System.out.println("Clone event1 has pitch = "+ev1.pitch);
    System.out.println("Old event2 isNull: " +event2.pitch.isNull());
  }

}
