/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.form;
import herman.elements.*;
import herman.properties.*;
// import herman.pitch.harmony.Queue;
import herman.pitch.io.*;

import herman.pitch.harmony.*;
import herman.pitch.melody.*;

/** 
 * The Contour class attaches pitch contour information to the melodic events.
 */
 
public class Contour {

/** 
 *  The in queue for accompaniment events and chords 
 */
  public static Queue accompInQueue = new Queue();
/** 
 *  The in queue for melody events and event groups
 */
  public static Queue melodyInQueue = new Queue();
/** 
 *  The in queue for percussion events.
 */
  public static Queue percussionInQueue = new Queue();

/** 
 *  Percentage of time new notes should be the same the previous note
 */
  public static float uniformity = 30.0f;
/** 
 *  Percentage of time new notes should deviate from established contour.
 */
  public static float variety = 20.0f;


  private static final int MAXelements = 10;
  private static final int MAXbreaks = 4;
  private static final float PHRASEcontourDOMINATION = 75.0f;
  private static final int INITIAL = -100;
  private static final float HIGH = 500.0f;

  private static int contourIndex = 0;
  private static int manualPhraseContour = 0;
  private static boolean createFlag = true;
  private static int[] contour = new int[MAXelements];
  private static int[][] miniContour = new int[MAXelements][MAXelements + 2];
  private static int phraseProgressIndex = 0;
  private static int currentMiniContourIndex = 0;
  private static int currentPhraseDir = 0;
  private static int egIndex = 0;
  private static int currentID = 0;
  private static float[] currentPhraseContour = new float[MAXbreaks];
  private static final float[][] phraseContour = 
  {{1.0f,100.0f,HIGH,HIGH},
   {-1.0f, 100.0f, HIGH, HIGH},
   {1.0f,33.33f, 66.66f, 100.0f},
   {-1.0f,33.33f, 66.66f, 100.0f},
   {1.0f, 50.0f, 100.0f, HIGH},
   {-1.0f, 50.0f, 100.0f, HIGH}};

/**
 *  Activates the Contour module, causing it to design and attach contour
 *   instructions to the events in its melody InQueue (if these events do not
 *   already have contour info attached).  The elements are then sent to the 
 *   Labeller.
 */
  public static void activate() {
    MusicElement elem;

     //First handle the melody:
    while (melodyInQueue.size() > 0) {
      elem = (MusicElement)melodyInQueue.pop();
       if (applyContour(elem)) {                 //applyContour returns true
	                                        // if elem is an event
	Labeller.melodyInQueue.push(elem);
	}
    }

     //Next handle the accompaniment:
    while (accompInQueue.size() > 0) {
      elem = (MusicElement)accompInQueue.pop();
      //System.out.println("Accomp thing time = " +elem.startTime);
      Labeller.accompInQueue.push(elem);
    }

     //Next handle the percussion:
    while (percussionInQueue.size() > 0) {
      elem = (MusicElement)percussionInQueue.pop();
      Labeller.percussionInQueue.push(elem);
    }

    Labeller.activate();
  }

/** 
 *  Force the phrase contour to be consistently "up" or "down," depending on 
 *   the String argument.
 */
  public static void forceContour( String dir) {
    if (dir.equals("up")) manualPhraseContour = 1;
    else if (dir.equals("down")) manualPhraseContour = -1;
    else {manualPhraseContour = 0;}
  }

/** 
 *  Clears the old phrase contour information and prepares for a new 
 *   phrase.
 */
  public static void reset() {
    for (int i=0; i<MAXelements; i++) {
      miniContour[i][0] = INITIAL;
      miniContour[i][1] = INITIAL;
    }
    for (int i=0; i<contour.length; i++) {
      contour[i] = INITIAL;
    }
    currentMiniContourIndex = 0;
    phraseProgressIndex = 0;
   

    //Choose a new phrase contour
    if (manualPhraseContour == 1) {
      currentPhraseContour = phraseContour[0];
    } else if (manualPhraseContour == -1) {
      currentPhraseContour = phraseContour[1];
    } else {
      float rand = ((float)java.lang.Math.random())*100.0f;
      if (rand < 25.0f) {currentPhraseContour = phraseContour[2];}
      else if (rand < 50.0f) {currentPhraseContour = phraseContour[3];}
      else if (rand < 75.0f) {currentPhraseContour = phraseContour[4];}
      else {currentPhraseContour = phraseContour[5];}
    }
  }
    

  /* Decide whether elem is a event or event group and react appropriately
   *
   */
  private static boolean applyContour(MusicElement elem) {
    if (elem.getMusicDefn().equals("event group")) {    //elem is event group
      EventGroup eg = (EventGroup)elem;
      System.out.println("EventGroup ID# = " +eg.ID);
      getEventGroupContour(eg);
      contourIndex = 0;
      return false;
    }
    else if (elem.getMusicDefn().equals("note")) {  //elem is an event
      Event event = (Event)elem;
      String contour = event.eventInfo.getSecond();

      //Check current contour
      if ((contour.equals("same"))||
	  (contour.equals("up"))||
	  (contour.equals("down"))) {
	//don't over-ride old contour
      } else {
	applyEventContour(event);	
      }
      return true;
    }
    return false;
  }

  /*  Use event group contour (set as the contour[] array) and event group
   *   progress to decide contour for individual events.  If the event group
   *   contour hasn't been set, assign contour randomly (based on event
   *   group overall direction).
   */
  private static void applyEventContour(Event event) {
    int eventContour = 0;

    float rand = ((float)java.lang.Math.random())*100.0f;
    float rand2 = ((float)java.lang.Math.random())*100.0f;

    if (!createFlag) {
      System.out.println("Using old contour");
      if (rand > variety) {eventContour = contour[egIndex];}
      //Otherwise, modify the stored contour
      else {
	if (contour[egIndex]==1) {
	  if (rand2 > 50.0f) {eventContour = 0;}
	  else {eventContour = -1;}
	}
	else if (contour[egIndex]== -1) {
	  if (rand2 > 50.0f) {eventContour = 0;}
	  else {eventContour = 1;}
	}
	else {
	  if (rand2 < PHRASEcontourDOMINATION) {
	    eventContour = currentPhraseDir;
	  } else {
	    if (currentPhraseDir == 1) eventContour = -1;
	    else {eventContour = 1;}
	  }
	}   
      }
    }

    //Need to create the contour pattern
    else {  
      if (rand >= uniformity) {
	if (rand2 < PHRASEcontourDOMINATION) {
	  eventContour = currentPhraseDir;
	} else {
	  if (currentPhraseDir == 1) eventContour = -1;
	  else {eventContour = 1;}
	}
      }
      else {eventContour = 0;}
      contour[contourIndex] = eventContour;
      contourIndex++;
    }

    if (eventContour==1) {event.eventInfo.setSecond("up");}
    else if (eventContour==0) {event.eventInfo.setSecond("same");}
    else if (eventContour==-1) {event.eventInfo.setSecond("down");}

    egIndex++;
  }

  /* Decide on a contour pattern (if any) for the event group
   *
   */
  private static void getEventGroupContour(EventGroup eg) {
    int sum = 0;

    //Check to see if contour instantiated, and store if necessary
    for (int i=0; i<contour.length; i++) {
      sum = sum + contour[i];
    }
    if (sum!=(contour.length*INITIAL)) {  //current contour instantiated
      if (getMiniContour(currentID,currentPhraseDir) == -1) {  
	setMiniContour(currentID,currentPhraseDir);   //store current contour
	System.out.println("Storing Contour...");
      }
    }

    //Check phrase progress vs. Phrase contour to get current phrase dir
    getEventGroupDir(eg);

    //Check to see if event group has been given contour in this dir:
    int index = getMiniContour(eg.ID,currentPhraseDir);
    if (index == -1) {  //No contour assigned
      
      //reset the contour array
      for (int i=0; i<contour.length; i++) {
	contour[i] = INITIAL;
      }
      createFlag = true;
    }
    else {
      for (int i=2; i<miniContour.length; i++) {
	contour[i-2] = miniContour[index][i];
      }
      createFlag = false;
    }

    egIndex = 0;  
    currentID = eg.ID;
  }

  /* Get the mini-contour index with these parameters if it exists.
   *  miniContour is an int[x][y] with [x][0] being the event group ID
   *  and [x][1] being the phraseDir when that contour was generated
   */
  private static int getMiniContour(int ID, int dir) {
    int result = -1;

    for (int i = 0; i<MAXelements; i++) {
      if (ID == miniContour[i][0]) {
	if (dir == miniContour[i][1]) {
	  result = i;
	}
      }
    }
    
    return result;
  }

  /* Store the current contour in miniContour with these parameters.
   *  miniContour is an int[x][y] with [x][0] being the event group ID
   *  and [x][1] being the phraseDir when that contour was generated
   */
  private static void setMiniContour(int ID, int dir) {
    miniContour[currentMiniContourIndex][0] = ID;
    miniContour[currentMiniContourIndex][1] = dir;

    for (int i = 2; i<(MAXelements+2); i++) {
      miniContour[currentMiniContourIndex][i] = contour[i-2];
    }    
   currentMiniContourIndex++;
  }

  /*  Use the currentPhraseContour and phrase progress to assign an
   *  overall direction to the event group contour
   */
  private static void getEventGroupDir(EventGroup eg) {
    float timePercent = (float)(eg.startTime/
				PhraseForm.currentPhrase.duration)*100.0f;
    float tDPercent = (float)((eg.startTime+eg.duration)/
			 PhraseForm.currentPhrase.duration)*100.0f;

    //if start of phrase:
    if (phraseProgressIndex==0) {
      currentPhraseDir = (int)currentPhraseContour[0];
      phraseProgressIndex++;
    }

    //if passed the current break point:
    else if (timePercent > currentPhraseContour[phraseProgressIndex]) {
      phraseProgressIndex++;
      currentPhraseDir = (int)currentPhraseContour[phraseProgressIndex];
    }

    //if stretching over current break point
else if (tDPercent > currentPhraseContour[phraseProgressIndex]) {

      float stretch = ((currentPhraseContour[phraseProgressIndex] -
		       timePercent)/(tDPercent - timePercent))*100.0f;
      if (stretch >= 50.0f) {
	currentPhraseDir = (int)currentPhraseContour[phraseProgressIndex];
	phraseProgressIndex++;
      } else {
	phraseProgressIndex++;
	getEventGroupDir(eg);
      }
    }

    // otherwise, contained below break point:
    else {
      currentPhraseDir = (int)currentPhraseContour[phraseProgressIndex];
      //phraseProgressIndex++;
    }
  }
	
/**
 *  For testing
 */
  public static void main(String[] args) {
    PitchStartUp.initialize();
    PhraseForm.initialize();
    SentenceForm.initialize();
    Labeller.setThreshold(1);
    ChordTones.setMaxNonChordTonePercent(60.0f);
    ChordTones.setMinMatchProb(-10.0f);
    float[] prefer = 
    {15.0f,
     20.0f,20.0f,
     15.0f,15.0f,
     10.0f,10.0f,
     8.0f,
     2.0f, 2.0f,
     -3.0f, -3.0f,
    -5.0f,
    -5.0f, -5.0f};
     
    IntervalPreference.setManualPreference(prefer);
    KeyControl.setCurrentMode("minor");
    KeyControl.setCurrentKeyType(9);
    
    Chord[] chord = new Chord[6];
    Event[] accompEvent = new Event[6];
    Event[] melodyEvent = new Event[12];
    PhraseForm.currentPhrase.duration = 12;

    for (int i = 0; i<12; i++) {
      melodyEvent[i] = new Event();
    }
      
    for (int i = 0; i<6; i++) {
      chord[i] = new Chord();
      accompInQueue.push(chord[i]);
      chord[i].startTime = 2*i;
      chord[i].duration = 2;
      accompEvent[i] = new Event();
      accompEvent[i].startTime = 2*i;
      accompEvent[i].duration = 2;
      accompInQueue.push(accompEvent[i]);      
    }    

     for (int i = 0; i<10; i++) {
      melodyEvent[i].startTime = i;
      melodyEvent[i].duration = 1;
      melodyInQueue.push(melodyEvent[i]);
    }  

     melodyEvent[10].startTime = 10;
      melodyEvent[10].duration = 2;
      melodyInQueue.push(melodyEvent[10]);

    /*  for (int i = 0; i<6; i++) {
      melodyEvent[i].startTime = i;
      melodyEvent[i].duration = 1;
      melodyInQueue.push(melodyEvent[i]);
    } 

    //  melodyEvent[4].supConChord.addElem(chord[2]);
    // melodyEvent[4].supConChord.addElem(chord[3]);
    // melodyEvent[4].supConChord.addElem(chord[4]);
    melodyEvent[6].startTime = 6;
      melodyEvent[6].duration = 4;
      melodyInQueue.push(melodyEvent[6]); */

    //chord[0].harmonyInfo.setLocation("sentence start");
    //melodyEvent[0].eventInfo.setLocation("sentence start");

    System.out.println("Starting....");
    System.out.println(" ");

/*   

    Modulation.setModulation("minor");
    
    Cadence.setCadence("pre-cadence");

    */

    activate();
  }
}
