/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.eventprocess;
import herman.misc.*;

public class EventProcess extends Thread
{
  /**
   * The thread which runs as this module
   */
  private static EventProcess thread;


  /**
   * Initialise this module
   */
  public static void init()
  {
    thread = new EventProcess();
    thread.start();
  }
      

  /**
   * The main run method
   */
  public void run()
  {
    // this runs forever (well, sort of, ish, like)
    while(true)
    {
      // we will wait until we're told to do someherman..
      thread.suspend();
      
      // loop until getNextFewEvents() indicates it was successful
      while(true)
      {

	//Update parameters
	herman.mapper.Mapper.applyTensionLevel();

	// right, getNextFewEvents was successful, so we can exit now
	if (herman.rhythm.Rhythm.getNextFewEvents())
	  break;
	
	// hmm.. we'll just sleep for a wee bit & try getNextFewEvents
	// again
	try
	{
	  thread.sleep(10);
	}
	catch(InterruptedException e)
	{
	  throw new FatalError(e.toString());
	}
      }
    }
  }

  /**
   * Indicates that we want the next few events to be sent 
   */
  public static void activate()
  {
    thread.resume();
  }
}

