/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.elements;
import herman.properties.*;
import herman.rhythm.RhythmStuff;

/** 
 * The Phrase class is a CHARM constituent that represents a musical phrase.
 **/

public class Phrase extends MusicElement 
                    implements Cloneable {

/* Properties */


  public RhythmStuff rhythmStuff = new RhythmStuff();

/**
 * Contains transformation info. relevant to the Transformer
 * @see TransformInfo
 */
   public TransformInfo transformation = new TransformInfo();

/**
 * Contains location information relevant to the Pitch Instantiator
 * @see PitchInfo
 */
   public PitchInfo phraseInfo = new PitchInfo(); 
  

   public long tension = 0;

  public long velChangeCount =0;
  public long speedChangeCount =0;

/* ************* Possible super-constituents *********** */
  /**
   * A list of sentences that are the super-constituents of this phrase.
   */
  public MusicElementList supConSentence = new MusicElementList();


/* ********** Possible particle lists ****************** */  
  /**
   * A list of the melodic event groups that are particles of this phrase.
   */
  public MusicElementList partMelEventGroup = new MusicElementList();

  /**
   * A list of the chords that are particles of this phrase.
   */
  public MusicElementList partChord = new MusicElementList();

  /**
   * A list of the percussion events that are particles of this phrase.
   */
  public MusicElementList partPercEvent = new MusicElementList();


  /** 
   *  Allows cloning
   */
  public Object clone() {
    Phrase phrase = null;
    phrase = (Phrase)super.clone();

    //Clone handles:
 phrase.partMelEventGroup = (MusicElementList)phrase.partMelEventGroup.clone();
    phrase.partChord = (MusicElementList)phrase.partChord.clone();
    phrase.partPercEvent = (MusicElementList)phrase.partPercEvent.clone();
    phrase.phraseInfo = (PitchInfo)phrase.phraseInfo.clone();

    //Reset other handles:
    phrase.supConSentence = new MusicElementList();
    phrase.transformation = new TransformInfo();
    //phrase.phraseInfo = new PitchInfo();

    return phrase;
  }

    
}
