/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.elements;

/** This is the MusicElement class, which will be used as the superclass for
 * all of the musical elements in the Java CHARM system.
 * 
 */

public class MusicElement implements Cloneable {
  
  private StringBuffer musicDefn = new StringBuffer();
  public StringBuffer description = new StringBuffer();

  //Other Stuff....?

/**
 * The startTime of the event, in milliseconds relative to the start of the 
 *   phrase. 
 */  
  public long startTime;
/**
 * The duration of the event 
 */
  public long duration;

  public void setMusicDefn(String defn) {
    musicDefn.insert(0,defn);
    musicDefn.setLength(defn.length());
  }
  
  public String getMusicDefn() {
    return musicDefn.toString();
  }

/** 
 *  Allows cloning
 */
  public Object clone() {
    Object o = null;
    try {
      o = super.clone();
    } catch (CloneNotSupportedException e) {
      System.out.println("MusicElement can't clone");
    }

    //System.out.println("Cloning MusicElements is bad!!!");
    return o;
  }
}
