/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.elements;
import herman.properties.*;

/** 
 * The EventGroup class is a constituent of rhythmically related events.
 **/

public class EventGroup extends MusicElement {
/* ************** Properties *********************** */ 

  private StringBuffer musicDefn = new StringBuffer("event group");

/**
 * The identification for this event group
 */
  public int ID = 0;

/* *********** Possible super-constituents ************ */ 
  /**
   * A list of phrases that are the super-constituents of this event group.
   */
  public MusicElementList supConPhrase = new MusicElementList();


  /**
   * A list of melody events that are the particles of this event group.
   */
  public MusicElementList partMelEvent = new MusicElementList();


/** 
 * Returns the musical definition of the Event Group class (ie, "event group")
 */
  public String getMusicDefn() {
    return musicDefn.toString();
  }

   /** 
   *  Allows cloning
   */
  public Object clone() {
    EventGroup eg = null;
    eg = (EventGroup) super.clone();

    //Clone handles:
    eg.partMelEvent = (MusicElementList)eg.partMelEvent.clone();

    //Reset other handles:
    eg.supConPhrase = new MusicElementList();

    return eg;
  }
}
