/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.elements;
import herman.properties.*;

/** 
 * The Event class is the proto-type of CHARM <em>events</em>, which 
 * represent individual musical notes.
 **/

public class Event extends MusicElement
                   implements Cloneable  {
/* ************** Properties *********************** */ 

  private StringBuffer musicDefn = new StringBuffer("note");


/**
 * The pitch of the event 
 * @see Pitch
 */
  public Pitch pitch = new Pitch();

/**
 * The musical key of the event (ie, the key under which it was instantiated)
 * @see Key
 */
  public Key key = new Key();

/**
 * The amplitude of the event 
 * @see Amplitude
 */
  public Amplitude amplitude = new Amplitude();

/**
 * The timbre of the event 
 * @see Timbre
 */
  public Timbre timbre = new Timbre();
  
/**
 * Contains location information relevant to the Pitch Instantiator. The 
 * first element is for location; the second for contour.
 * @see PitchInfo
 */
  public PitchInfo eventInfo = new PitchInfo();


  public int velocity;

/* *********** Possible super-constituents ************ */ 
  /**
   * A list of chords that are the super-constituents of this event.
   */
  public MusicElementList supConChord = new MusicElementList();

/** 
 * Returns the musical definition of the Event class (ie, "event")
 */
  public String getMusicDefn() {
    return musicDefn.toString();
  }

  public String toString() {
    return ("Time = " + startTime + ", " + pitch);
  }

 /** 
   *  Allows cloning
   */
  public Object clone() {
    Event event = null;
    event = (Event)super.clone();

    //Clone handles:
    
    event.eventInfo = (PitchInfo)event.eventInfo.clone();
    event.timbre = (Timbre)event.timbre.clone();
    event.amplitude = (Amplitude)event.amplitude.clone();
    event.pitch = (Pitch)event.pitch.clone();
    event.key = (Key)event.key.clone();

    //Reset other handles:
    event.supConChord = new MusicElementList();

    return event;
  }
}
