/* 
   Herman
   (c) 1998 Andrew de Quincey, adq@tardis.ed.ac.uk
   (c) 1998 Thomas Stapleford
   See README.TXT for copying/distribution/modification details.
*/

package herman.elements;

import herman.properties.*;

/** 
 * This is the Chord class, which is represents the musical chord 
 * structure in the system. It extends the MusicElement class.
 */

public class Chord extends MusicElement
                   implements Cloneable {

/* *****************  Properties ***********************  */

  private StringBuffer musicDefn = new StringBuffer("chord");

/**
 * The musical key of the chord
 * @see Key
 */
  public Key key = new Key();

/**
 * The basic chord type of the chord
 * @see ChordType
 */
  public ChordType chordType = new ChordType();

/**
 * The inversion of the chord
 * @see Inversion
 */
  public Inversion inversion = new Inversion();

/**
 * Contains location information relevant to the Pitch Instantiator
 * @see PitchInfo
 */
  public PitchInfo harmonyInfo = new PitchInfo();


/* ******* Possible super-constituents *****************   */

  /**
   * A list of the phrases that are the super-constituents of this chord.
   */
  public MusicElementList supConPhrase = new MusicElementList();

  /*
   * A list of the accompaniment blocks that are the super-constituents of
   *  this chord.
   *
   * public MusicElementList supConAccompBlock = new MusicElementList();
   */

  //Possible particles
  /**
   * A list of the melodic events that are particles of this chord.
   */
  public MusicElementList partMelEvent = new MusicElementList();

  /**
   * A list of the accompaniment events that are particles of this chord.
   */
  public MusicElementList partAccompEvent = new MusicElementList();

  /**
   * A list of the percussion events that are particles of this chord.
   */
  public MusicElementList partPercEvent = new MusicElementList();


/** 
 * Returns the musical definition of the Chord class (ie, "chord")
 */
  public String getMusicDefn() {
    return musicDefn.toString();
  }


  /** 
   *  Allows cloning
   */
  public Object clone() {

    Chord chord = null;
  
      chord = (Chord)super.clone();
   

    //Clone handles:
    chord.partAccompEvent = (MusicElementList)chord.partAccompEvent.clone();
    chord.key = (Key)chord.key.clone();
    chord.chordType = (ChordType)chord.chordType.clone();
    chord.harmonyInfo = (PitchInfo)chord.harmonyInfo.clone();

    //Reset other handles:
    chord.supConPhrase = new MusicElementList();
    chord.partMelEvent = new MusicElementList();
    chord.partPercEvent = new MusicElementList();

    return chord;
  }
}
