;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                          ;
; Funkplay                                                                 ;
;                                                                          ;
; FunkTracker by JsNO/SuperReal - 1994,1995                                ;
;                                                                          ;
;This thing is a little bit better than the old EXAMPLE.ASM thing i had    ;
;previously. This program loads two modules and then plays them. It        ;
;basically demonstrates the use of FUNKOBJ and how to setup funk modules   ;
;previously loaded in memory. This is a one up from before, as you had     ;
;to load and play them one at a time (as you may have seen in my Music     ;
;Contest 3 demo)                                                           ;
;                                                                          ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
ideal
p386
model flat
stack  1024
codeseg

extrn debug           : near
Zero_Addr             dd ?
Environment_Address   dd ?
PSP_Address           dd ?
_0B8000h              dd ?

extrn                 FNK_autodetect : near
extrn                 FNK_card_deinit : near
extrn                 FNK_card_init : near
extrn                 FNK_setup_player : near
extrn                 FNK_PLAY : near
extrn                 FNK_STOP : near
extrn                 FNK_teststatus : near
extrn                 FNK_set_mvolume : near
extrn                 FNK_get_mvolume : near
extrn                 FNK_set_sr : near

dma_buffer            dd ?
our_songname1         db "c:\topend\songs\jsnork.fnk",0
song_buffer1          dd ?
our_songname2         db "c:\topend\songs\j-dance.fnk",0
song_buffer2          dd ?

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;@STDIO MACRO: Modified By Adam Seychell 14/03/94 in V1.02
macro @stdio string
local @@tttext, @@skip
  jmp    @@skip
  ifb    <string>
@@tttext:
  db     "$"
  else
@@tttext:
  db     string, "$"
  endif
@@skip:
  push   eax edx
  lea    edx,[@@tttext]
  mov    ah,9
  int    21h
  pop    edx eax
endm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
; NB/ i find that these are better for reading the keyboard, as the INT16 ;
; routines are interrupt executed, and therefore mask and starve our      ;
; playback code causing cracking and slowness in playback.                ;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc key_pressed2
  push   esi
  mov    esi,[Zero_Addr]
  add    esi,41ah
  mov    ax,[esi]
  cmp    ax,[word esi+2]
  jne    @@l
  pop    esi
  clc
  ret
@@l:
  movzx  eax,ax
  add    eax,400h
  add    eax,[Zero_Addr]
  mov    ax,[word eax]
  pop    esi
  stc
  ret
endp

proc get_key
@@l:
  call   key_pressed2
  jnc    @@l
  mov    eax,0
  int    16h
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
proc load_song
  mov    eax,3d00h                                      ;open file
  int    21h
  jc     @@load_error
  mov    ebx,eax

  mov    eax,4202h                                      ;alloc song mem
  xor    edx,edx
  int    21h
  push   eax eax
  mov    eax,4200h
  xor    edx,edx
  int    21h
  pop    edx
  add    edx,1000h
  mov    eax,0EE42h
  Int    31h
  jc     @@mem_alloc_error
  pop    ecx                                            ;read *.FNK file
  mov    ah,3fh
  int    21h

  mov    ah,3eh                                         ;close file
  int    21h
  clc
  ret
@@mem_alloc_error:
  @stdio "Memory Error. Program unable to run."
  stc
  ret
@@load_error:
  @stdio "can't find FNK file."
  stc
  ret
endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;                                                                         ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
Start_Funkplay:
;  call   debug
  cld
  mov    ax,0EE02h
  int    31h
  neg    ebx
  mov    [Zero_Addr],ebx
  add    ebx,0b8000h
  mov    [_0B8000h],ebx
  mov    [Environment_Address],edi
  mov    [PSP_Address],esi

  mov    eax,0EE41h                                     ;first things first,
  Int    31h                                            ;DMA memory. Always
  jc     @@mem_alloc_error                              ;alloc it first thing
  mov    [dma_buffer],edx

  mov    al,0
  call   FNK_set_sr

  mov    bl,0ffh                                        ;autodetect card
  mov    eax,0ffffh                                     ; & IRQ and DMA
  call   FNK_autodetect                                 ;BL=FF means accept
  jc     @@card_not_found                               ;the first thing that
                                                        ;is detected

  mov    eax,[dma_buffer]                               ;fire up mixxer/tracker
  call   FNK_card_init                                  ;code that runs in backround

  @stdio "loading song #1..."                           ;load song 1
  mov    edx,offset our_songname1
  call   load_song
  jc     @@load_fail
  mov    [song_buffer1],edx

  @stdio "loading song #2..."                           ;load song 2
  mov    edx,offset our_songname2
  call   load_song
  jc     @@load_fail
  mov    [song_buffer2],edx

;;;;;;;;;;
  @stdio "playing song #1...."                          ;play song 1
  mov    eax,[song_buffer1]
  call   FNK_setup_player                               ;setup current song
  call   FNK_PLAY                                       ;play music

@@wloop1:                                               ;this would be your
  call   key_pressed2                                   ;demo code here
  jc     @@end1
  call   FNK_teststatus                                 ;exit if music has
  je     @@wloop1                                       ;ended
  jmp    @@enxt
@@end1:
  call   FNK_STOP                                       ;stop music
  call   get_key

;;;;;;;;;;
@@enxt:
  @stdio "playing song #2...."                          ;play song 2
  mov    eax,[song_buffer2]
  call   FNK_setup_player
  call   FNK_PLAY

@@wloop2:
  call   key_pressed2
  jc     @@end2
  call   FNK_teststatus
  je     @@wloop2
@@end2:
  call   FNK_STOP
  call   get_key

@@load_fail:
  call   FNK_card_deinit                                ;deinit player

  @stdio "byeee!..."
@@abort:
  mov    eax,0EE40h                                     ;dealloc DMA memory
  int    31h
  mov    eax,0EE40h                                     ;dealloc song memory 1
  int    31h
  mov    eax,0EE40h                                     ;dealloc song memory 2
  int    31h
  mov    eax,4c00h                                      ;end program
  int    21h
@@card_not_found:
  @stdio "Soundcard not Detected."
  jmp    @@abort
@@mem_alloc_error:
  @stdio "Memory Error. Program unable to run."
  jmp    @@abort
@@load_error:
  @stdio "can't find FNK file."
  jmp    @@abort
ends

end Start_Funkplay
