; Dorsola's FoxPlay 98 - mIRC interface script.
; Please refer to help documentation for more information.
; ==================

ON 1:START {
  if %fp_autostart {
    %fp_action = UpdateOptions $readini $mircini dde servicename
    fp_startup
  }
}

ON 1:LOAD {
  if $script(PM_GUI.MRC)   != $null { unload -rs PM_GUI.MRC }
  if $script(PM_AUDIT.MRC) != $null { unload -rs PM_AUDIT.MRC }
  if $script(FP_GUI.MRC)   != $null { unload -rs FP_GUI.MRC }
  if $script(FP_AUDIT.MRC) != $null { unload -rs FP_AUDIT.MRC }
  if $script(FP_MSYS.MRC)  != $null { unload -rs FP_MSYS.MRC }
  
  if %fp_version <= 6.22 { unset %fp* }
  unset %fp_version
}

alias fp_startup {
  %fp_temptemp = $readini $mircini dde serverstatus
  if %fp_temptemp != on { .ddeserver on }
  
  %fp_version = $dde FoxPlay version ""
  if %fp_version == $null {
    if %fp_exepath == $null { %fp_exepath = $dir="Where is foxplay.exe?" .\foxplay.exe }
    if %fp_exepath == $null { halt }
    
    if %fp_action == $null { .run %fp_exepath $readini $mircini dde servicename }
    else { .run -n %fp_exepath $readini $mircini dde servicename }
  }
  else {
    fp_sendDDE setservicename $readini $mircini dde servicename
    if %fp_action != $null { fp_sendDDE %fp_action }
    unset %fp_action
  }
}

alias fp_DDEstartup {
  %fp_temptemp = $readini $mircini dde serverstatus
  if %fp_temptemp != on { .ddeserver on }
  
  %fp_version = $dde FoxPlay version ""
  if %fp_version != $null {
    fp_sendDDE setservicename $readini $mircini dde servicename
    if %fp_action != $null { fp_sendDDE %fp_action }
    unset %fp_action
  }
}

alias foxplay {
  if $1 == $null { %fp_temp = NULL }
  else { %fp_temp = $1- }
  
  %fp_action = foxplay %fp_temp
  fp_startup
}

alias repeat {
  %fp_temp = $dde FoxPlay currentfile ""
  if $1 isnum { queue_do %fp_temp $1 }
  else { foxplay %fp_temp }
}

alias desc {
  %fp_temp = $dde FoxPlay reqInfoColor $$1-
  
  if %fp_temp == $null {
    if $dde FoxPlay version "" != $null { echo -a 4*** (FoxPlay) No information available for $1- }
    else { echo -a 4*** ERROR: FoxPlay must be running in order to retrieve any information about its files. }
  }
  else { /say $1- $+ : %fp_temp }
}

alias fp_sendDDE dde FoxPlay $1 "" $2-
alias fp_stop fp_sendDDE stop ""
alias clearqueue fp_sendDDE clearqueue ""

alias fp_setDirIncomingDefault fp_sendDDE SetDirIncoming %fp_tempLen $getdir

alias queue_do {
  %fp_servicename = $readini $mircini DDE ServiceName
  %fp_temp_txt = $$1-
  %fp_sizetext = $dde foxplay queuesize ""
  unset %fp_queuetemp
  
  :loop_queue
  %fp_temp = $fp_getFName(%fp_temp_txt)
  if %fp_temp == $null { goto end_queue }
  
  %fp_temptok = $gettok(%fp_temp,0,32) + 1
  %fp_temp3 = %fp_temptok $+ -
  %fp_temp_txt = $gettok(%fp_temp_txt,%fp_temp3,32)
  
  %fp_temp2 = $gettok(%fp_temp_txt,1,32)
  
  if %fp_temp2 isnum 1-999 {
    %fp_temp_txt = $gettok(%fp_temp_txt,2-,32)
    
    %fp_temp3 = $chr(32)
    fp_sendDDE queueRepeat %fp_servicename %fp_temp2 $replace(%fp_temp,%fp_temp3,)
  }
  else { fp_sendDDE queue %fp_servicename %fp_temp }
  goto loop_queue
  
  :end_queue
  fp_sendDDE queueDONE %fp_servicename
}

alias fp_queuedone {
  if %fp_queuetemp != $null {
    %fp_queuetemp = $gettok(%fp_queuetemp,2-,32)
    echo $1 7*** (FoxPlay) Added to queue: 12 $+ %fp_queuetemp $+ 
    if %fp_doreq != $null { 
      .notice %fp_doreq (FoxPlay) I've queued the following: %fp_queuetemp %fp_sizetext
      unset %fp_doreq
    }
  }
  else if %fp_doreq == $null { echo $1 4*** (FoxPlay) No files were added to your queue. }
}

alias clearcue clearqueue
alias cue unset %fp_doreq | queue_do $1-
alias queue unset %fp_doreq | queue_do $1-
alias playmidi foxplay $1-
alias stopmidi fp_stop
alias foxstop fp_stop

alias fp_getFName {
  unset %fp_temp
  %fp_tempTnum = 0
  %fp_tempTok = $false
  
  :loop_getFName
  inc %fp_tempTnum
  %fp_tempTtoken = $gettok( $1-, %fp_tempTnum, 32 )
  
  if %fp_tempTtoken == $null { goto end_getFName }
  else {
    %fp_temp = %fp_temp %fp_tempTtoken
    
    if . isin %fp_tempTtoken {
      %fp_tempText = $right( %fp_temp, 4 )
      %fp_tempText2 = $right( %fp_temp, 3 )
      
      if %fp_tempText isin .mid;.mod;.s3m;.mp3;.wav; || %fp_tempText2 isin .xm;.it;.rm;.ra; {
        %fp_tempTok = $true
        goto end_getFName
      }
    }
  }
  goto loop_getFName
  
  :end_getFName
  if %fp_tempTok == $false { unset %fp_temp }
  unset %fp_tempT*
  return %fp_temp
}  

menu status,menubar,channel,query,system {
  FoxPlay %fp_version
  .$fpm_playing:fp_startup
  .-
  .Play $fpm_next_in_queue:foxplay
  .$fpm_repeat:repeat
  .Stop Playing:foxstop
  .Clear Queue:clearqueue
  .-
  .General Options
  ..Auto-Start FoxPlay on mIRC Start $fpm_stat(%fp_autostart):if %fp_autostart { set %fp_autostart $false } | else { set %fp_autostart $true }
  ..Allow people to request WAV files $fpm_stat(%fp_sendwavs):if %fp_sendwavs { set %fp_sendwavs $false } | else { set %fp_sendwavs $true }
  ..-
  ..Random-Pick Files $fpm_stat_remote(%fp_randomize):     fp_toggle_opt %fp_randomize randompick
  ..Local Info Display $fpm_stat(%fp_localinfo):           fp_toggle_opt %fp_localinfo localdisplay
  ..Remote-Control Mode $fpm_stat(%fp_rcmode):             fp_toggle_opt %fp_rcmode remotecontrol
  ..Accept Jukebox-style requests $fpm_stat(%fp_acceptreq):fp_toggle_opt %fp_acceptreq acceptrequests
  ..Broadcast in Color $fpm_stat(%fp_showcolor):           fp_toggle_opt %fp_showcolor showcolor
  
  .MIDI Options
  ..Playback $fpm_stat(%fp_play_midi):      fp_toggle_opt %fp_play_midi play midis
  ..Auto-Request $fpm_stat(%fp_areq_midi):  fp_toggle_opt %fp_areq_midi areq midis
  ..Show to Public $fpm_stat(%fp_show_midi):fp_toggle_opt %fp_show_midi show midis
  
  .MOD Options
  ..Playback $fpm_stat(%fp_play_mods):      fp_toggle_opt %fp_play_mods play mods
  ..Auto-Request $fpm_stat(%fp_areq_mods):  fp_toggle_opt %fp_areq_mods areq mods
  ..Show to Public $fpm_stat(%fp_show_mods):fp_toggle_opt %fp_show_mods show mods
  
  .MP3 Options
  ..Playback $fpm_stat(%fp_play_mp3s):      fp_toggle_opt %fp_play_mp3s play mp3s
  ..Auto-Request $fpm_stat(%fp_areq_mp3s):  fp_toggle_opt %fp_areq_mp3s areq mp3s
  ..Show to Public $fpm_stat(%fp_show_mp3s):fp_toggle_opt %fp_show_mp3s show mp3s

  .RealAudio Options
  ..Playback $fpm_stat(%fp_play_rams):      fp_toggle_opt %fp_play_rams play rams
  ..Auto-Request $fpm_stat(%fp_areq_rams):  fp_toggle_opt %fp_areq_rams areq rams
  ..Show to Public $fpm_stat(%fp_show_rams):fp_toggle_opt %fp_show_rams show rams
  .-
  .Help
  ..FoxPlay Help:run $scriptdir $+ foxplay.hlp
  ..FoxPlay Homepage:run http://www.descent2.com/dorsola/fplay.htm
}


; Aliases used with popup menu
; ============================

alias fp_toggle_opt {
  %fp_servicename = $readini $mircini dde servicename
  
  if $1 { fp_sendDDE SetOption %fp_servicename $2- 0 }
  else { fp_sendDDE SetOption %fp_servicename $2- 1 }
}

alias fpm_playing {
  %fp_temp = $dde FoxPlay PlayerState ""
  if %fp_temp == $null { return Run FoxPlay.exe }
  else { return %fp_temp }
}

alias fpm_next_in_queue {
  %fp_tempfile = $dde FoxPlay nextinqueue ""
  if %fp_tempfile != $null { return next queued file: %fp_tempfile }
  else { return a random file }
}

alias fpm_repeat {
  %fp_tempfile = $dde FoxPlay currentfile ""
  if %fp_tempfile != $null { return Repeat %fp_tempfile }
}

alias fpm_stat {
  if $1 { return (ON) }
  else { return (OFF) }
}

alias fpm_stat_remote {
  if %fp_rcmode { return (OFF) }
  elseif $1 { return (ON) }
  else { return (OFF) }
}

; Event triggers
; ==============

CTCP 1:VERSION:*:ctcpreply $nick SCRIPT Equipped with Dorsola's FoxPlay 98 %fp_version $+ !

alias fps_store {
  if .wav !isin $1- {
    %fps_file = $scriptdir $+ fp_files.ini
    
    %fps_line1 = $readini %fps_file $1 file1
    %fps_line2 = $readini %fps_file $1 file2
    %fps_line3 = $readini %fps_file $1 file3
    %fps_line4 = $readini %fps_file $1 file4
    %fps_line5 = $readini %fps_file $1 file5
    
    if %fps_line5 != $null {
      writeini %fps_file $1 file1 %fps_line2
      writeini %fps_file $1 file2 %fps_line3
      writeini %fps_file $1 file3 %fps_line4
      writeini %fps_file $1 file4 %fps_line5
      writeini %fps_file $1 file5 $2-
    }
    elseif %fps_line1 == $null { writeini %fps_file $1 file1 $2- }
    elseif %fps_line2 == $null { writeini %fps_file $1 file2 $2- }
    elseif %fps_line3 == $null { writeini %fps_file $1 file3 $2- }
    elseif %fps_line4 == $null { writeini %fps_file $1 file4 $2- }
    else { writeini %fps_file $1 file5 $2- }
  }
}

CTCP 1:MP3:* {
  %fp_tempfile = $fp_getFName( $2- )
  if %fp_lastnick != $nick && %fp_lastfile != %fp_tempfile { 
    %fp_servicename = $readini $mircini DDE servicename
    fp_sendDDE ctcpsound %fp_servicename $nick %fp_tempfile
  }
  
  %fp_lastnick = $nick
  %fp_lastfile = %fp_tempfile
  fps_store $nick %fp_tempfile
  
  if $chan != $null { echo 7 $chan ( $+ MP3: $nick %fp_tempfile $+ ) }
  else { echo 7 -a ( $+ MP3: $nick %fp_tempfile $+ ) }
  halt
}  

CTCP 1:SOUND:* {
  %fp_tempfile = $fp_getFName( $2- )
  if $right(%fp_tempfile,4) == .wav { goto FP_END }
  if %fp_tempfile != $null {
    if %fp_lastnick != $nick || %fp_lastfile != %fp_tempfile {
      %fp_servicename = $readini $mircini DDE servicename
      fp_sendDDE ctcpsound %fp_servicename $nick %fp_tempfile
    }
    
    %fp_lastnick = $nick
    %fp_lastfile = %fp_tempfile
    fps_store $nick %fp_tempfile
    
    if $chan != $null { echo 7 $chan ( $+ SOUND: $nick %fp_tempfile $+ ) }
    else { echo 7 -a ( $+ SOUND: $nick %fp_tempfile $+ ) }
    halt
  }
  :FP_END
}

on 1:TEXT:*!*:* {
  %fp_tempfile = $fp_getFName( $2- )
  
  if %fp_tempfile != $null {
    if $1 == ! $+ $me {
      if .wav !isin %fp_tempfile {
        %fp_tempC = $chr(32)
        %fp_temppath = $dde foxplay getPath $replace(%fp_tempfile,%fp_tempC,)
        if %fp_temppath != $null { dcc send $nick " $+ %fp_temppath $+ " }
        halt
      }
      elseif %fp_sendwavs {
        %fp_temppath = $findfile($wavedir,%fp_tempfile,1)
        if %fp_temppath != $null { dcc send $nick " $+ %fp_temppath $+ " }
        halt
      }
    }
    elseif $1 == !request && %fp_acceptreq {
      set %fp_doreq $nick
      queue_do $2-
    }
  }
  unset %fp_temp*
}

ON 1:FILERCVD:*.mid,*.mod,*.s3m,*.xm,*.it,*.mp3 {
  %fp_dirIncoming = $fp_checkIncomingDir
  if $filename != %fp_dirIncoming $+ $nopath($filename) {
    .rename $filename " $+ %fp_dirIncoming $+ $nopath($filename) $+ "
  }
}

ON 1:FILESENT:*.mid,*.mod,*.s3m,*.xm,*.it,*.mp3 {
  %fp_temp = $chr(32)
  %fp_temp = $dde FoxPlay reqInfoFPL $replace($nopath($filename),%fp_temp,)
  if %fp_temp != $null {
    %fp_tempC = $chr(32)
    .timer 1 3 .ctcp $nick FP98_FILEINFO $replace($nopath($filename),%fp_tempC,_) %fp_temp
  }
}

alias fp_checkIncomingDir {
  if %fp_dirIncoming == $null {
    %fp_dirIncoming = $getdir
    %fp_templen = $len(%fp_dirIncoming) - 1
    %fp_dirIncoming = $left(%fp_dirIncoming, %fp_templen)
  }
  return %fp_dirIncoming
}

CTCP 1:FP98_FILEINFO:? {
  ; remote FP98 sent me a file and is now sending info on it.
  ; Aggressive approach allows for spaced filenames.
  
  if $3 == $null { halt }
  
  %fp_temp_file = $fp_getFName( $3- )
  
  if %fp_temp_file != $null {
    %fp_dirIncoming = $fp_checkIncomingDir
    if %fp_temp_file != $2 { .rename " $+ %fp_dirIncoming $+ $2 $+ " " $+ %fp_dirIncoming $+ %fp_temp_file $+ " }
    write " $+ %fp_dirIncoming $+ fp_new.fpi" $3-
  }
  halt
}

CTCP 1:FP98_USERINFOREQ:? {
  ; remote FP98 user requests info about a file.
  ; File 1 = local filename
  ; File 2 = remote filename
  
  if $3 == $null { halt }
  
  %fp_tempfile = $fp_getFName( $2- )
  if %fp_tempfile != $null {
    %fp_templen1 = $len(%fp_tempfile) + 1
    %fp_templen2 = $mid($2-, %fp_templen1, 0)
    %fp_tempfile2 = $fp_getFName( $mid( $2-, %fp_templen1, %fp_templen2 ) )
    
    if %fp_tempfile2 != $null {
      %fp_servicename = $readini $mircini dde servicename
      fp_sendDDE UserInfoReq %fp_servicename $nick $replace(%fp_tempfile,32,127) $replace(%fp_tempfile2,32,127)
    }
  }
  unset %fp_temp*
  halt
} 

ON 1:CTCPREPLY:FP98_USERINFOREQ* {
  fp_sendDDE Suggestion $readini $mircini dde servicename $nick $2-
  halt
}

ON 1:NICK {
  %fps_file = $scriptdir $+ fp_files.ini
  
  %fps_line1 = $readini %fps_file $nick file1
  %fps_line2 = $readini %fps_file $nick file2
  %fps_line3 = $readini %fps_file $nick file3
  %fps_line4 = $readini %fps_file $nick file4
  %fps_line5 = $readini %fps_file $nick file5
  
  if %fps_line1 != $null { writeini %fps_file $newnick file1 %fps_line1 }
  if %fps_line2 != $null { writeini %fps_file $newnick file2 %fps_line2 }
  if %fps_line3 != $null { writeini %fps_file $newnick file3 %fps_line3 }
  if %fps_line4 != $null { writeini %fps_file $newnick file4 %fps_line4 }
  if %fps_line5 != $null { writeini %fps_file $newnick file5 %fps_line5 }
  remini %fps_file $nick
}

alias fps_filename {
  %fps_file = $scriptdir $+ fp_files.ini
  %fps_temp = file $+ $2
  %fps_temp2 = $readini %fps_file $1 %fps_temp
  if %fps_temp2 == $null { return }
  else { return %fps_temp2 }
}

alias fps_manreq .msg $1 ! $+ $1 $fps_filename($1,$2) 12(FoxPlay Manual Request)

alias fps_inforeq {
  %fps_file = $fps_filename($1,$2)
  
  %fps_temp = $chr(32)
  %fps_temp = $dde FoxPlay reqInfoFPL $replace(%fps_file,%fps_temp,)
  
  if %fps_temp != $null { 
    .ctcp $1 FP98_USERINFOREQ %fps_file %fps_file
    echo -a 10*** Requested info from $1 about %fps_file $+ 
  }
  else { echo -a 4*** ERROR: %fps_file is not in your playlist! }
  unset %fps*
}

alias fps_sendsugg {
  %fps_file = $fps_filename($1,$2)
  
  %fps_temp2 = $chr(32)
  %fps_temp = $dde FoxPlay reqInfoFPL $replace(%fps_file,%fps_temp2,)
  
  if %fps_temp != $null { 
    .ctcpreply $1 FP98_USERINFOREQ %fps_temp
    echo -a *** Sent info about %fps_file $+ : $dde FoxPlay reqInfoColor $replace(%fps_file,%fps_temp2,)
  }
  else { echo -a 4*** ERROR: %fps_file is not in your playlist! }
}

menu nicklist {
  FoxPlay %fp_version
  .$fps_filename($snick($chan,1),5)
  ..Request this file:fps_manreq $1 5
  ..-
  ..Request info for my copy of this file:fps_inforeq $1 5
  ..Suggest info from my copy:fps_sendsugg $1 5
  
  .$fps_filename($snick($chan,1),4)
  ..Request this file:fps_manreq $1 4
  ..-
  ..Request info for my copy of this file:fps_inforeq $1 4
  ..Suggest info from my copy:fps_sendsugg $1 4
  
  .$fps_filename($snick($chan,1),3)
  ..Request this file:fps_manreq $1 3
  ..-
  ..Request info for my copy of this file:fps_inforeq $1 3
  ..Suggest info from my copy:fps_sendsugg $1 3
  
  .$fps_filename($snick($chan,1),2)
  ..Request this file:fps_manreq $1 2
  ..-
  ..Request info for my copy of this file:fps_inforeq $1 2
  ..Suggest info from my copy:fps_sendsugg $1 2
  
  .$fps_filename($snick($chan,1),1)
  ..Request this file:fps_manreq $1 1
  ..-
  ..Request info for my copy of this file:fps_inforeq $1 1
  ..Suggest info from my copy:fps_sendsugg $1 1
  
  .-
  .Send a file...:dcc send $snick($chan,1) $dir="Choose file to send..." *.mid;*.mod;*.s3m;*.xm;*.it;*.mp3
}
